const Ilda = require('./Ilda');

class IldaContent {
  static contentId() {
    return 'ilda';
  }

  static parsePluginCommand(parser, command, args) {
    if (command.toUpperCase() !== 'ILDA') {
      return;
    }

    switch(parser.name.toUpperCase()) {
      case 'OPENDOOR':
        Ilda.openDoor();
        return true;
      case 'CLOSEDOOR':
        Ilda.closeDoor();
        return true;
      case 'CHAT':
        {
          const methods = Managers.Villagers.buildContextChatMethods('Ilda', parser.interpreter);
          Ilda.chat(methods);
        }
        return true;
    }
  }

  static getCurrentSchedule(villagerName) {
    if (villagerName.toLowerCase() != 'ilda') return;

    if (Managers.Weather.isBadWeather()) {
      return 'raining';
    }

    if (Managers.Time.weekDay === Days.MONDAY) {
      return 'monday';
    }

    return 'default';
  }
}

Managers.Content.registerContentClass(IldaContent);