const BaseVillager = require('../_system/BaseVillager');

class Gary extends BaseVillager {
  static getVillagerName() {
    return 'Gary';
  }

  static validMaps() {
    return [
      Maps.ORANGE_TOWN,
      Maps.BEACH,
      Maps.PETTING_ZOO,
      Maps.FOREST,
    ];
  }

  static openDoor() {
    $gameMap.openVillagerDoor('Duke');
  }

  static closeDoor() {
    $gameMap.closeVillagerDoor('Duke');
  }

  static onChangeTime() {
    if (!Switches.isGaryInTown) return;
    super.onChangeTime();
  }

  static onUpdateVillagers() {
    if (!Switches.isGaryInTown) return;
    super.onUpdateVillagers();
  }

  static onSetupMapEvents() {
    if (!Switches.isGaryInTown) return;
    super.onSetupMapEvents();
  }

  static chat(methods) {
    const { play } = methods;

    if (Managers.Items.hasAnyFish()) {
      return play('gary_buy_fish');
    }

    if ($gameMap._mapId === Maps.BEACH) {
      return play('gary_beach');
    }

    if (Managers.Time.hour < 12) {
      return play('gary_town_morning');
    }

    if ($gameMap._mapId === Maps.ORANGE_TOWN && Managers.Time.hour > 15) {
      return play('gary_town');
    }

    if ($gameMap._mapId === Maps.FOREST) {
      return play('gary_forest');
    }

    return play('gary_default');
  }  
}

Gary.register();

module.exports = Gary;