const Gary = require('./Gary');

class GaryContent {
  static contentId() {
    return 'gary';
  }

  static parsePluginCommand(parser, command, args) {
    if (command.toUpperCase() !== 'GARY') {
      return;
    }

    switch(parser.name.toUpperCase()) {
      case 'OPENDOOR':
        Gary.openDoor();
        return true;
      case 'CLOSEDOOR':
        Gary.closeDoor();
        return true;
      case 'FISHSHOP':
        $gameTemp.startNewFishContainer();
        Managers.Scenes.push(GameScenes.SellFish);
        return true;
      case 'CONFIRMSALE':
        {
          Managers.Items.gainGold(Variables.fishTotal);
          $gameTemp.clearFishContainer();
        }
        return true;
      case 'CANCELSALE':
        {
          const container = $gameTemp.getFishContainer();
          container.moveAllItems(Managers.Items.container);
          $gameTemp.clearFishContainer();
        }
        return true;
      case 'CHAT':
        {
          const methods = Managers.Villagers.buildContextChatMethods('Gary', parser.interpreter);
          Gary.chat(methods);
        }
        return true;
    }
  }

  static getCurrentSchedule(villagerName) {
    if (villagerName.toLowerCase() != 'gary') return;

    if (!Managers.Relationship.isCharacterKnown('Gary')) {
      return 'out';
    }

    if (Managers.Time.weekDay !== Days.WEDNESDAY) {
      Switches.isGaryInTown = false;
      return 'out';
    }

    Switches.isGaryInTown = true;

    return 'default';
  }

  static checkCutscenes(mapId) {
    if (this.checkCutsceneGaryIntroduction(mapId)) return true;

    return false;
  }

  static checkCutsceneGaryIntroduction(mapId) {
    if (mapId !== Maps.BEACH) return false;
    if ($gameMap._mapId !== Maps.PETTING_ZOO) return false;
    if ($gamePlayer.isRiding()) return false;
    if ($gameParty.hasCompanion()) return false;

    if (Managers.Relationship.isCharacterKnown('Gary')) return false;
    if (Managers.Weather.isBadWeather()) return false;
    if (Managers.Time.weekDay !== Days.WEDNESDAY) return false;
    
    if (!Managers.Time.isBetweenTimes('08:00', '12:00')) return false;

    //Reserve the cutscene
    $gameTemp.reserveCutscene('gary_introduction_scene');
    $gamePlayer.backupTransferPosition();

    //Overrides the transfer data with fixed player position for the cutscene
    $gamePlayer.reserveTransfer(mapId, 10, 14, Direction.DOWN, 0, false);

    return true;
  }
}

Managers.Content.registerContentClass(GaryContent);