require('game/objects/CustomEvent');

Objects.Dancer = class Dancer extends Objects.CustomEvent {
  update() {
    super.update();

    this._lockPattern = true;

    if (this._dancerTimeOut === undefined) {
      this._dancerTimeOut = Utils.getFrameCount(10);
      return;
    }

    if (!this._dancerTimeOut) {
      this.nextDanceFrame();
      return;
    }

    this._dancerTimeOut--;
  }

  nextDanceFrame() {
    const defaultLength = 6;

    const allFrames = [
      // raise hands
      { index: 0, direction: 2, pattern: 0, frameLength: 10 },
      { index: 0, direction: 2, pattern: 1, frameLength: 10 },
      { index: 0, direction: 2, pattern: 2, frameLength: 10 },

      // foot kicking
      { index: 0, direction: 4, pattern: 0, frameLength: 10 },
      { index: 0, direction: 4, pattern: 1, frameLength: 10 },
      { index: 0, direction: 4, pattern: 2, frameLength: 10 },
      { index: 0, direction: 6, pattern: 0, frameLength: 10 },
      { index: 0, direction: 6, pattern: 1, frameLength: 10 },
      { index: 0, direction: 6, pattern: 2, frameLength: 10 },

      // foot kicking - reverse
      { index: 0, direction: 6, pattern: 1, frameLength: 10 },
      { index: 0, direction: 6, pattern: 0, frameLength: 10 },
      { index: 0, direction: 4, pattern: 2, frameLength: 10 },
      { index: 0, direction: 4, pattern: 1, frameLength: 10 },
      { index: 0, direction: 4, pattern: 0, frameLength: 10 },

      // foot kicking - going again
      { index: 0, direction: 4, pattern: 1, frameLength: 10 },
      { index: 0, direction: 4, pattern: 2, frameLength: 10 },
      { index: 0, direction: 6, pattern: 0, frameLength: 10 },
      { index: 0, direction: 6, pattern: 1, frameLength: 10 },
      { index: 0, direction: 6, pattern: 2, frameLength: 10 },

      // spinning
      { index: 0, direction: 8, pattern: 0, frameLength: defaultLength },
      { index: 0, direction: 8, pattern: 1, frameLength: defaultLength },
      { index: 0, direction: 8, pattern: 2, frameLength: defaultLength },
      { index: 1, direction: 2, pattern: 0, frameLength: defaultLength },
      { index: 1, direction: 2, pattern: 1, frameLength: defaultLength },
      { index: 1, direction: 2, pattern: 2, frameLength: defaultLength },
      { index: 1, direction: 4, pattern: 0, frameLength: defaultLength },
      { index: 1, direction: 4, pattern: 1, frameLength: defaultLength },

      // spinning
      { index: 0, direction: 8, pattern: 0, frameLength: defaultLength },
      { index: 0, direction: 8, pattern: 1, frameLength: defaultLength },
      { index: 0, direction: 8, pattern: 2, frameLength: defaultLength },
      { index: 1, direction: 2, pattern: 0, frameLength: defaultLength },
      { index: 1, direction: 2, pattern: 1, frameLength: defaultLength },
      { index: 1, direction: 2, pattern: 2, frameLength: defaultLength },
      { index: 1, direction: 4, pattern: 0, frameLength: defaultLength },
      { index: 1, direction: 4, pattern: 1, frameLength: defaultLength },

      // white effects
      { index: 1, direction: 4, pattern: 2, frameLength: 8 },
      { index: 1, direction: 6, pattern: 0, frameLength: 8 },
      { index: 1, direction: 6, pattern: 1, frameLength: 8 },
      { index: 1, direction: 6, pattern: 2, frameLength: 8 },

      // snake arms
      { index: 1, direction: 8, pattern: 0, frameLength: 10 },
      { index: 1, direction: 8, pattern: 1, frameLength: 10 },
      { index: 1, direction: 8, pattern: 2, frameLength: 10 },
      { index: 2, direction: 2, pattern: 0, frameLength: 10 },
      { index: 2, direction: 2, pattern: 1, frameLength: 10 },
      { index: 2, direction: 2, pattern: 2, frameLength: 10 },
      { index: 2, direction: 4, pattern: 0, frameLength: 10 },
      { index: 2, direction: 4, pattern: 1, frameLength: 10 },

      // going down
      { index: 2, direction: 4, pattern: 2, frameLength: defaultLength },
      { index: 2, direction: 6, pattern: 0, frameLength: defaultLength },
      { index: 2, direction: 6, pattern: 1, frameLength: defaultLength },
      { index: 2, direction: 6, pattern: 2, frameLength: defaultLength },
      { index: 2, direction: 8, pattern: 0, frameLength: defaultLength },
      { index: 2, direction: 8, pattern: 1, frameLength: defaultLength },
      { index: 2, direction: 8, pattern: 2, frameLength: defaultLength },

      // picking fabric
      { index: 3, direction: 2, pattern: 0, frameLength: defaultLength },

      // spinning fabric
      { index: 3, direction: 2, pattern: 1, frameLength: defaultLength },
      { index: 3, direction: 2, pattern: 2, frameLength: defaultLength },
      { index: 3, direction: 4, pattern: 0, frameLength: defaultLength },
      { index: 3, direction: 4, pattern: 1, frameLength: defaultLength },
      { index: 3, direction: 4, pattern: 2, frameLength: defaultLength },
      { index: 3, direction: 6, pattern: 0, frameLength: defaultLength },
      { index: 3, direction: 6, pattern: 1, frameLength: defaultLength },

      // // spinning fabric
      { index: 3, direction: 2, pattern: 1, frameLength: defaultLength },
      { index: 3, direction: 2, pattern: 2, frameLength: defaultLength },
      { index: 3, direction: 4, pattern: 0, frameLength: defaultLength },
      { index: 3, direction: 4, pattern: 1, frameLength: defaultLength },
      { index: 3, direction: 4, pattern: 2, frameLength: defaultLength },
      { index: 3, direction: 6, pattern: 0, frameLength: defaultLength },
      { index: 3, direction: 6, pattern: 1, frameLength: defaultLength },

      // throwing fabric
      { index: 3, direction: 6, pattern: 2, frameLength: defaultLength },
      { index: 3, direction: 8, pattern: 0, frameLength: defaultLength },
      { index: 3, direction: 8, pattern: 1, frameLength: defaultLength },
      { index: 3, direction: 8, pattern: 2, frameLength: defaultLength },
      { index: 4, direction: 2, pattern: 0, frameLength: defaultLength },
      { index: 4, direction: 2, pattern: 1, frameLength: defaultLength },
      { index: 4, direction: 2, pattern: 2, frameLength: defaultLength },
      { index: 4, direction: 4, pattern: 0, frameLength: defaultLength },
      { index: 4, direction: 4, pattern: 1, frameLength: defaultLength },
      { index: 4, direction: 4, pattern: 2, frameLength: defaultLength },

      // resetting
      { index: 4, direction: 6, pattern: 0, frameLength: defaultLength },
      { index: 4, direction: 6, pattern: 1, frameLength: defaultLength },
      { index: 4, direction: 6, pattern: 2, frameLength: defaultLength },
      { index: 4, direction: 8, pattern: 0, frameLength: defaultLength },
      { index: 4, direction: 8, pattern: 1, frameLength: defaultLength },
      { index: 4, direction: 8, pattern: 2, frameLength: defaultLength },
    ];

    let currentFrame = this._currentFrame || 0;

    let nextFrame = currentFrame + 1;
    if (nextFrame >= allFrames.length) {
      nextFrame = 0;
    }

    this._currentFrame = nextFrame;
    const frameData = allFrames[nextFrame];
    this._characterIndex = frameData.index;
    this._direction = frameData.direction;
    this._pattern = frameData.pattern;

    this._dancerTimeOut = Utils.getFrameCount(frameData.frameLength);
  }
};
