const BaseVillager = require('../_system/BaseVillager');

class Gabriel extends BaseVillager {
  static getVillagerName() {
    return 'Gabriel';
  }

  static validMaps() {
    return [
      Maps.ORANGE_TOWN,
      Maps.MOUNTAIN,
      Maps.RESTAURANT,
    ];
  }

  static onSetupMapEvents() {
    if (!Gabriel.isValidMap()) return;

    Managers.Villagers.createVillagerOnScheduledPosition('Gabriel');
    if ($gameMap._mapId == Maps.RESTAURANT && Managers.Time.hour == 18 && Managers.Time.weekDay >= 5) {
      Managers.CommonEvent.playEventAsync('gabriel_dance');
      return;
    }
  }

  static _chatDefaultSchedule(methods) {
    const { playOnePerWeekDay } = methods;
    // #ToDo: Companion

    if (playOnePerWeekDay(
      [
        'gabriel_weekly_sunday',
        'gabriel_weekly_monday',
        'gabriel_weekly_tuesday',
        'gabriel_weekly_wednesday',
        'gabriel_weekly_thursday',
        'gabriel_weekly_friday_and_saturday',
        'gabriel_weekly_friday_and_saturday'
      ])) {
      return true;
    }
  }

  static _chatWeekendSchedule(methods) {
    return Gabriel._chatDefaultSchedule(methods);
  }

  static chat(methods) {
    const { play } = methods;
    // #ToDo: Companion

    const schedule = Managers.Villagers.getCurrentSchedule('Gabriel');
    const chatFn = {
      default: Gabriel._chatDefaultSchedule,
      weekend: Gabriel._chatWeekendSchedule,
    }[schedule] || Gabriel._chatDefaultSchedule;

    if (chatFn(methods)) {
      return true;
    }

    return play('gabriel_default');
  }
}

Gabriel.register();
module.exports = Gabriel;
