const Gabriel = require('./Gabriel');

class GabrielContent {
  static contentId() {
    return 'gabriel';
  }

  static getCurrentSchedule(villagerName) {
    if (villagerName.toLowerCase() != 'gabriel') return;

    if (Managers.Time.weekDay >= 5) {
      return 'friday_saturday';
    }

    return 'default';
  }

  static parsePluginCommand(parser, command, args) {
    if (command.toUpperCase() !== 'GABRIEL') {
      return;
    }

    switch(parser.name.toUpperCase()) {
      case 'OPENDOOR':
        Gabriel.openDoor();
        return true;
      case 'CLOSEDOOR':
        Gabriel.closeDoor();
        return true;
      case 'CHAT':
        {
          const methods = Managers.Villagers.buildContextChatMethods('Gabriel', parser.interpreter);
          Gabriel.chat(methods);
        }
        return true;
    }
  }
}

Managers.Content.registerContentClass(GabrielContent);