const BaseVillager = require('../_system/BaseVillager');

class Duke extends BaseVillager {
  static getVillagerName() {
    return 'Duke';
  }

  static validMaps() {
    return [
      Maps.ORANGE_TOWN,
      Maps.BEACH,
      Maps.PETTING_ZOO,
      Maps.RESTAURANT
    ];
  }

  static onChangeTime() {
    if (!Switches.isDukeInTown) return;
    super.onChangeTime();
  }

  static onUpdateVillagers() {
    if (!Switches.isDukeInTown) return;
    super.onUpdateVillagers();
  }

  static onSetupMapEvents() {
    if (!Switches.isDukeInTown) return;
    super.onSetupMapEvents();
  }

  static chat(methods) {
    const { play, playOnePerWeekDay } = methods;
    // #ToDo: Companion


    if (Managers.Time.month === Seasons.SUMMER) {
      if ($gameMap._mapId == Maps.BEACH && Managers.Time.isBetweenTimes('10:30', '15:30')) {
        return play('duke_beach_shop');
      }

      if (Managers.Weather.isBadWeather()) {
        return play('duke_summer_bad_weather');
      }

      if (playOnePerWeekDay(
        [
          'duke_summer_sunday',
          // ['duke_summer_sunday','duke_summer_sunday_2','duke_summer_sunday_3'],
          'duke_summer_monday',
          // ['duke_summer_monday','duke_summer_monday_2','duke_summer_monday_3'],
          'duke_summer_tuesday',
          // ['duke_summer_tuesday','duke_summer_tuesday_2','duke_summer_tuesday_2',],
          'duke_summer_wednesday',
          // ['duke_summer_wednesday','duke_summer_wednesday_2','duke_summer_wednesday_2',],
          'duke_summer_thursday',
          // ['duke_summer_thursday','duke_summer_thursday_2','duke_summer_thursday_2',],
          'duke_summer_friday',
          // ['duke_summer_friday','duke_summer_friday_2','duke_summer_friday_2',],
          'duke_summer_saturday',
          // ['duke_summer_saturday','duke_summer_saturday_2','duke_summer_saturday_2',],
        ])) {
        return;
      }

      return play('duke_default');
    }

    if (Managers.Time.month === Seasons.SPRING) {
      if (playOnePerWeekDay(
        [
          'duke_spring_sunday',
          'duke_spring_monday',
          'duke_spring_tuesday',
          'duke_spring_wednesday',
          'duke_spring_thursday',
          'duke_spring_friday',
          'duke_spring_saturday'
        ])) {
        return;
      }

      return play('duke_default');
    }

    if (Managers.Time.month === Seasons.FALL) {
      return play('duke_fall');
    }

    return play('duke_default');
  }  
}

Duke.register();

module.exports = Duke;