const Duke = require('./Duke');

class DukeContent {
  static contentId() {
    return 'duke';
  }

  static parsePluginCommand(parser, command, args) {
    if (command.toUpperCase() !== 'DUKE') {
      return;
    }

    switch(parser.name.toUpperCase()) {
      case 'OPENDOOR':
        Duke.openDoor();
        return true;
      case 'CLOSEDOOR':
        Duke.closeDoor();
        return true;
      case 'CHAT':
        {
          const methods = Managers.Villagers.buildContextChatMethods('Duke', parser.interpreter);
          Duke.chat(methods);
        }
        return true;
    }
  }

  static getCurrentSchedule(villagerName) {
    if (villagerName.toLowerCase() != 'duke') return;

    if (!Managers.Relationship.isCharacterKnown('Duke')) {
      return 'out';
    }

    // He's only in town from the end of spring to the beginning of fall
    if (Managers.Time.yearDay < Constants.DUKE_MIN_DAY || Managers.Time.yearDay > Constants.DUKE_MAX_DAY) {
      Switches.isDukeInTown = false;
      return 'out';
    }

    Switches.isDukeInTown = true;

    if (Managers.Weather.isBadWeather()) {
      return 'inside';
    }

    if (Managers.Time.month == Seasons.SUMMER) {
      return 'summer';
    }

    return 'default';
  }

  static checkCutscenes(mapId) {
    if (this.checkCutsceneDukeIntroduction(mapId)) return true;

    return false;
  }

  static checkCutsceneDukeIntroduction(mapId) {
    if (mapId !== Maps.ORANGE_TOWN) return false;
    if ($gameMap._mapId !== Maps.FARM) return false;
    if ($gamePlayer.isRiding()) return false;
    if ($gameParty.hasCompanion()) return false;

    if (Managers.Relationship.isCharacterKnown('Duke')) return false;

    if (Managers.Time.yearDay < Constants.DUKE_MIN_DAY) return false;
    if (Managers.Time.yearDay > Constants.DUKE_MAX_DAY) return false;
    if (!Managers.Time.isBetweenTimes('06:00', '22:00')) return false;

    //Reserve the cutscene
    $gameTemp.reserveCutscene('duke_introduction_scene');

    //Overrides the transfer data with fixed player position for the cutscene
    $gamePlayer.reserveTransfer(mapId, 3, 79, Direction.UP, 0, false);

    return true;
  }
}

Managers.Content.registerContentClass(DukeContent);