const BaseVillager = require('../_system/BaseVillager');

class Devin extends BaseVillager {
  static getVillagerName() {
    return 'Devin';
  }

  static validMaps() {
    return [
      Maps.GENERAL_STORE,
      Maps.ORANGE_TOWN,
      Maps.LIBRARY,
      Maps.FARM
    ];
  }

  static checkIfVillagerShouldLeaveParty() {
    if (Managers.Time.isBetweenTimes('22:15', '23:59') || Managers.Time.isBetweenTimes('00:00', '05:59')) {
      Managers.CommonEvent.playEvent('devin_leave_party_to_sleep');
      return;
    }
  }

  static openDoor() {
    $gameMap.openVillagerDoor('Serge');
  }

  static closeDoor() {
    $gameMap.closeVillagerDoor('Serge');
  }

  static chat(methods) {
    const { play, playOnceADay, playOneDayPerWeek, playTwoDaysPerMonth, playOncePerYear, playDuringOneDayOnly, playOnce, playOnceAWeek } = methods;
    // #ToDo: Companion

    // #ToDo: sequential chats

    // Chilling chats are triggered both in the morning (in front of the store) and at night (in front of the library)
    const chillingChats = () => {
      if (Managers.Weather.isRaining() && Managers.Time.month !== Seasons.WINTER) {
        if (playOneDayPerWeek('devin_rain_will_make_farm_plentiful')) return true;
      }

      if (Switches.playedDevinHeartEvent0 && !Switches.playedDevinHeartEvent0B && !Managers.History.wasConversationEverPlayed('devin_comment_event_0')) {
        return play('devin_comment_event_0');
      }

      switch(Managers.Time.month) {
        case Seasons.SPRING:
          if (playOneDayPerWeek('devin_spring_1')) return true;
          if (playOneDayPerWeek('devin_spring_2')) return true;
          if (playOneDayPerWeek('devin_spring_3')) return true;

          if (playOncePerYear('devin_joke_2')) return true;
          break;
        case Seasons.SUMMER:

          break;
        case Seasons.FALL:
          if (playOneDayPerWeek('devin_fall_1')) return true;
          if (playOneDayPerWeek('devin_fall_2')) return true;
          if (playOneDayPerWeek('devin_fall_3')) return true;

          break;
        case Seasons.WINTER:
          if (playOneDayPerWeek('devin_winter_1')) return true;
          if (playOneDayPerWeek('devin_winter_2')) return true;
          if (playOneDayPerWeek('devin_winter_3')) return true;
          break;
      }

      if (Managers.Time.month != Seasons.SPRING) {
        if (playOncePerYear('devin_joke_1')) return true;
      }
    };

    if (Managers.Time.isBetweenTimes('00:00', '06:43')) {
      return play('devin_too_early');
    }

    // If it's summer and Devin is outside and it's sunny - Higher priority
    if (Managers.Time.month === Seasons.SUMMER && $gameMap._mapId === Maps.ORANGE_TOWN && Managers.Weather.isSunny()) {
      if (playOnceAWeek('devin_complain_about_summer_1')) return;
    }

    // If it's raining or having a storm and Devin is picking the shipment
    if (Managers.Weather.isBadWeather() && Managers.Time.isBetweenTimes('06:44', '09:00')) {
      return play('devin_working_on_bad_weather');
    }

    // Devin is between the store door and your shipping bin
    if (Managers.Time.isBetweenTimes('06:44', '07:59')) {
      return play('devin_going_to_your_farm');
    }

    // Devin just picked up your shipped items and is going back to the store, comment about how much the player shipped
    if (Managers.Time.isBetweenTimes('08:00', '09:00')) {
      return play('devin_going_back_to_store');
    }

    // If it's summer and Devin is outside and it's sunny - Lower priority
    if (Managers.Time.month === Seasons.SUMMER && $gameMap._mapId === Maps.ORANGE_TOWN && Managers.Weather.isSunny()) {
      if (playOneDayPerWeek('devin_complain_about_summer_1')) return;
      if (playOneDayPerWeek('devin_complain_about_summer_2')) return;
      if (playOneDayPerWeek('devin_complain_about_summer_3')) return;
      if (playOneDayPerWeek('devin_complain_about_summer_4')) return;
    }

    // Either in front or inside the store
    if (Managers.Time.isBetweenTimes('09:17', '15:09')) {
      if (Managers.Time.yearDay === Festivals.CANDY - 1) {
        return play('devin_announce_candy_day_tomorrow');
      }

      if (Managers.Time.yearDay === Festivals.CANDY) {
        return play('devin_announce_candy_day_today');
      }

      // Between 09:17 and 09:57, Devin is in front of the store;
      if (Managers.Time.isBetweenTimes('09:17', '09:57')) {
        // if the player is still missing a tool after a few days
        if (Managers.Time.totalDays >= 4) {
          if (!Switches.hasIronSickle || !Switches.hasIronHammer || !Switches.hasIronAxe) {
            return playOnceADay('devin_missing_tools');
          }
        }

        // Advice about not having to rush
        if (playDuringOneDayOnly('devin_hint_1')) return;

        // Complaining about being yelled at
        if (playTwoDaysPerMonth('devin_complaining_about_complaints')) return;

        if (chillingChats()) return;
        
        if (playOneDayPerWeek('devin_dont_ship_too_much_1')) return;
        if (playOneDayPerWeek('devin_woke_up_early')) return;
      }

      // Between 09:58 and 15:09, Devin is inside the store
      if (Managers.Time.isBetweenTimes('09:58', '15:09')) {
        // Advice about not having to rush
        if (playDuringOneDayOnly('devin_hint_1')) return;

        // Store specific chats
        if (playOneDayPerWeek('devin_store_chat_1')) return;
        if (playOneDayPerWeek('devin_store_chat_2')) return;
        if (playOneDayPerWeek('devin_store_chat_3')) return;
        if (playOneDayPerWeek('devin_store_chat_4')) return;
        if (playOneDayPerWeek('devin_store_chat_5')) return;

        if (Managers.Time.hour >= 14) {
          if (playOneDayPerWeek('devin_store_chat_6')) return;
        }

        if (playOnce('devin_slip_about_nathalia')) return;
      }

      if (Switches.unlockedSprinklers) {
        if (playOneDayPerWeek('devin_new_project_idea')) return;
      }
    }

    // Going to the library
    if (Managers.Time.isBetweenTimes('15:10', '15:41')) {
      if (Managers.Time.month !== Seasons.SUMMER && !Managers.Weather.isBadWeather()) {
        if (playOneDayPerWeek('devin_good_day_for_a_walk')) return;
      }

      if (playDuringOneDayOnly('devin_ask_about_farm_life_1')) return;
      if (playOneDayPerWeek('devin_complaining_about_work_1')) return;
      if (playOneDayPerWeek('devin_ask_about_farm_life_2')) return;
      if (playOneDayPerWeek('devin_complaining_about_work_2')) return;

      if (Managers.Weather.isBadWeather()) {
        if (Managers.Weather.isRaining()) {
          if (playOneDayPerWeek('devin_rain_will_make_farm_plentiful')) return;
        }

        if (playOneDayPerWeek('devin_go_meet_nathalia')) return;
      }

      // #ToDo: More "Going to the library" chats
      return play('devin_complaining_about_work_2');
    }

    // Inside the library
    if (Managers.Time.isBetweenTimes('15:42', '18:15')) {
      if (playDuringOneDayOnly('devin_ask_about_farm_life_1')) return;
      if (playOneDayPerWeek('devin_ask_about_farm_life_2')) return;
      if (playOneDayPerWeek('devin_library_1')) return;

      if (playDuringOneDayOnly('devin_complain_about_viktor')) return;
      if (playDuringOneDayOnly('devin_talk_about_auto_hammer')) return;
      if (playDuringOneDayOnly('devin_talk_about_auto_hammer_2')) return;
      if (playDuringOneDayOnly('devin_talk_about_nathalias_gift')) return;

      // #ToDo: More library chats
      return play('devin_library_1');
    }

    // In front of the library
    if (Managers.Time.isBetweenTimes('18:16', '21:15')) {
      if (playOneDayPerWeek('devin_good_evening_1')) return;

      if (chillingChats()) return;

      // #ToDo: More chats here
      return play('devin_good_evening');
    }

    // Going home
    if (Managers.Time.isBetweenTimes('21:16', '21:41')) {
      if (playOneDayPerWeek('devin_good_evening_2')) return;
      if (playOneDayPerWeek('devin_good_evening_3')) return;

      return play('devin_good_evening');
    }

    // Home
    if (Managers.Time.isBetweenTimes('21:42', '22:10')) {
      return play('devin_too_late');
    }

    // Should be asleep, but just to be sure.
    if (Managers.Time.isBetweenTimes('22:11', '23:59')) {
      return play('devin_too_late');
    }

    if (Managers.Time.month === Seasons.SUMMER && $gameMap._mapId === Maps.ORANGE_TOWN && Managers.Weather.isSunny()) {
      // #ToDo: More summer hating chats
      return play('devin_complain_about_summer_4');
    }

    return play('devin_default');
  }
}

Devin.register();
module.exports = Devin;
