const Devin = require('./Devin');

class DevinContent {
  static contentId() {
    return 'devin';
  }

  //------------------------------------------------------
  //---- HOOKS
  //------------------------------------------------------  
  static checkCutscenes(mapId) {
    if (!Managers.Relationship.isCharacterKnown('Devin')) return false;
    if ($gamePlayer.isRiding()) return false;
    
    if (!$gameParty.hasCompanion()) {
      if (this.checkCutsceneDevinBookAboutMagic(mapId)) return true;
      if (this.checkCutsceneDevinKnowsMagic(mapId)) return true;
      if (this.checkCutsceneDevinGifts1(mapId)) return true;
      if (this.checkCutsceneDevinGifts2(mapId)) return true;
      if (this.checkCutsceneDevinGifts3(mapId)) return true;
      if (this.checkCutsceneDevinGifts4(mapId)) return true;
      if (this.checkCutsceneRichardQuestions(mapId)) return true;
    } else {
      if (this.checkCutsceneDevinDate1(mapId)) return true;
      if (this.checkCutsceneDevinDate2(mapId)) return true;
    }

    return false;
  }

  static parsePluginCommand(parser, command, args) {
    if (command.toUpperCase() !== 'DEVIN') {
      return;
    }

    switch(parser.name.toUpperCase()) {
      case 'OPENDOOR':
        Devin.openDoor();
        return true;
      case 'CLOSEDOOR':
        Devin.closeDoor();
        return true;
      case 'CHAT':
        {
          const methods = Managers.Villagers.buildContextChatMethods('Devin', parser.interpreter);
          Devin.chat(methods);
        }
        return true;
    }
  }

  static callContextChat(villagerName, methods) {
    if (villagerName !== 'Devin') return;

    Devin.chat(methods);
    return true;
  }

  static isVillagerAvailableToHangOut(villagerName) {
    if (villagerName !== 'Devin') return;

    if (!Managers.Time.isBetweenTimes('09:00', '20:59')) {
      return false;
    }

    return true;
  }

  static getLetterList() {
    const letters = [];

    if (this.checkSprinklerFinishedLetter()) {
      letters.push('mailbox_sprinkler_finished');
    }

    if (this.checkSuperSprinklerFinishedLetter()) {
      letters.push('mailbox_super_sprinkler_finished');
    }

    return letters;
  }


  //------------------------------------------------------
  //---- OWN METHODS  
  //------------------------------------------------------  

  static checkCutsceneDevinBookAboutMagic(mapId) {
    if (Switches.playedDevinFindingMagicBook) return false;
    if (Switches.devinOnAProject) return false;

    if (mapId !== Maps.LIBRARY) return false;
    if ($gameMap._mapId !== Maps.ORANGE_TOWN) return false;

    if (!Managers.Time.isBetweenTimes('15:55', '18:15')) return false;

    if (!Managers.Relationship.isCharacterKnown('Devin')) return false;
    if (!Managers.Relationship.isCharacterKnown('Annie')) return false;

    //Reserve the cutscene
    $gameTemp.reserveCutscene('devin_finds_magic_book');

    return true;
  }

  static checkCutsceneDevinKnowsMagic(mapId) {
    if (Switches.playedDevinKnowsMagic) return false;
    if (Switches.devinOnAProject) return false;
    if (!Switches.unlockedSprinklers) return false;
    if (!Switches.playedAnnieZeroHearts) return false;
    if (Variables.sprinklersMade < 10) return false;
    if (Managers.History.getShippedItems('big-blue-crystal') < 1) return false;


    if (mapId !== Maps.LIBRARY) return false;
    if ($gameMap._mapId !== Maps.ORANGE_TOWN) return false;

    if (!Managers.Time.isBetweenTimes('15:55', '18:15')) return false;

    $gameTemp.reserveCutscene('devin_studies_magic');
    $gamePlayer.reserveTransfer(mapId, 9, 13, Direction.UP, 0, false);
    Switches.hidePlayer = true;
    return true;
  }

  static checkCutsceneDevinGifts1(mapId) {
    if (Switches.playedDevinHeartEvent0) return false;

    if (mapId !== Maps.ORANGE_TOWN) return false;
    if ($gameMap._mapId == Maps.LIBRARY) return false;

    if (Managers.Time.hour < 18) return false;
    if (Managers.Time.hour >= 20) return false;

    if (!Managers.Relationship.isCharacterKnown('Nathalia')) return false;
    if (Managers.Relationship.getHeartsNum('Devin') < 0.5) return false;

    if (!Managers.Items.canGainItemId('sandwich')) return false;
    if (!Managers.Items.canGainItemId('chocolate-icecream')) return false;
    if (Managers.Weather.isBadWeather()) return false;

    if (!Managers.Time.isBetweenTimes('18:30', '19:30')) return false;

    Managers.Time.hour = 19;
    Managers.Time.minute = 3;
    Managers.Time.seconds = 0;
    Managers.Time.updateTime();

    $gamePlayer.backupTransferPosition();

    //Overrides the transfer data with fixed player position for the cutscene
    $gamePlayer.reserveTransfer(mapId, 17, 41, Direction.DOWN, 0, false);
    Switches.hidePlayer = true;

    $gameTemp.reserveCutscene('devin_events_gift_1');
    return true;
  }

  static checkCutsceneDevinGifts2(mapId) {
    if (Switches.playedDevinHeartEvent0B) return false;
    if (!Switches.playedDevinHeartEvent0) return false;

    if (mapId !== Maps.ORANGE_TOWN) return false;
    if ($gameMap._mapId == Maps.GENERAL_STORE) return false;

    if (Managers.Time.hour < 10) return false;
    if (Managers.Time.hour >= 12) return false;
    if (Managers.Weather.isBadWeather()) return false;

    if (!Managers.Relationship.isCharacterKnown('Devin')) return false;
    if (!Managers.Relationship.isCharacterKnown('Serge')) return false;

    if (!Managers.Time.isBetweenTimes('10:00', '12:00')) return false;

    $gamePlayer.backupTransferPosition();

    //Overrides the transfer data with fixed player position for the cutscene
    $gamePlayer.reserveTransfer(mapId, 5, 41, Direction.DOWN, 0, false);
    Switches.hidePlayer = true;

    $gameTemp.reserveCutscene('devin_events_gift_2');
    return true;
  }

  static checkCutsceneDevinGifts3(mapId) {
    if (Switches.playedDevinHeartEvent0C) return false;
    if (!Switches.playedDevinHeartEvent0B) return false;

    if (mapId !== Maps.RESTAURANT) return false;
    if ($gameMap._mapId != Maps.ORANGE_TOWN) return false;

    if (Managers.Time.hour != 16) return false;

    if (!Managers.Relationship.isCharacterKnown('Devin')) return false;
    if (!Managers.Relationship.isCharacterKnown('Benjamin')) return false;
    if (!Managers.Relationship.isCharacterKnown('Chloe')) return false;

    $gamePlayer.backupTransferPosition();

    //Overrides the transfer data with fixed player position for the cutscene
    $gamePlayer.reserveTransfer(mapId, 19, 14, Direction.DOWN, 0, false);
    Switches.hidePlayer = true;

    Managers.Time.hour = 17;
    Managers.Time.minute = 0;
    Managers.Time.seconds = 0;
    Managers.Time.updateTime();

    $gameTemp.reserveCutscene('devin_events_gift_3');
    return true;
  }

  static checkCutsceneDevinGifts4(mapId) {
    if (Switches.playedDevinHeartEvent0D) return false;
    if (!Switches.playedDevinHeartEvent0C) return false;

    if (mapId !== Maps.ORANGE_TOWN) return false;
    // if ($gameMap._mapId !== Maps.FARM) return false;

    if (Managers.Time.hour != 19) return false;

    if (!Managers.Relationship.isCharacterKnown('Devin')) return false;
    if (!Managers.Relationship.isCharacterKnown('Julia')) return false;
    if (Managers.Weather.isBadWeather()) return false;

    $gamePlayer.backupTransferPosition();

    //Overrides the transfer data with fixed player position for the cutscene
    $gamePlayer.reserveTransfer(mapId, 59, 27, Direction.DOWN, 0, false);
    Switches.hidePlayer = true;

    Managers.Time.hour = 20;
    Managers.Time.minute = 0;
    Managers.Time.seconds = 0;
    Managers.Time.updateTime();

    $gameTemp.reserveCutscene('devin_events_gift_4');
    return true;
  }

  static checkCutsceneRichardQuestions(mapId) {
    if (Switches.playedDevinEventRichardQuestions) return false;
    if (!Switches.playedDevinHeartEvent0D) return false;

    if (mapId !== Maps.GENERAL_STORE) return false;
    if ($gameMap._mapId !== Maps.ORANGE_TOWN) return false;

    if (!Managers.Relationship.isCharacterKnown('Devin')) return false;
    if (!Managers.Relationship.isCharacterKnown('Richard')) return false;

    if (Managers.Relationship.getHeartsNum('Devin') < 1) return false;

    $gameTemp.reserveCutscene('devin_heart_event_one');
    return true;
  }  

  static checkSprinklerFinishedLetter() {
    if (!Switches.devinFinishingSprinkler) return false;

    Switches.devinFinishingSprinkler = false;
    Switches.devinOnAProject = false;
    
    return true;
  }

  static checkSuperSprinklerFinishedLetter() {
    if (!Switches.devinFinishingSuperSprinkler) return false;

    Switches.devinFinishingSuperSprinkler = false;
    Switches.devinOnAProject = false;
    
    return true;
  }

  static checkCutsceneDevinDate1(mapId) {
    if (Switches.playedDevinFirstDate) return false;
    if (!Switches.playedDevinEventRichardQuestions) return false;

    if (mapId !== Maps.MOUNTAIN) return false;
    if ($gameMap._mapId != Maps.ORANGE_TOWN) return false;

    if (!$gameParty.isVillagerOnParty('Devin')) return false;
    if (Managers.Time.hour < 10) return false;
    if (Managers.Time.hour >= 14) return false;
    if (Managers.Relationship.getHeartsNum('Devin') < 2) return false;

    Managers.Time.hour = 14;
    Managers.Time.minute = 3;
    Managers.Time.seconds = 0;
    Managers.Time.updateTime();

    //Overrides the transfer data with fixed player position for the cutscene
    $gamePlayer.reserveTransfer(mapId, 70, 73, Direction.LEFT, 0, false);
    $gameParty.removeVillager('Devin');
    $gameTemp.reserveCutscene('devin_first_date');
    return true;
  }

  static checkCutsceneDevinDate2(mapId) {
    if (Switches.playedDevinSecondDate) return false;
    if (!Switches.playedDevinFirstDate) return false;
    if (!Switches.playedDevinEventRichardQuestions) return false;

    if (mapId !== Maps.BEACH) return false;
    if ($gameMap._mapId != Maps.PETTING_ZOO) return false;

    if (!$gameParty.isVillagerOnParty('Devin')) return false;
    if (Managers.Time.hour < 20) return false;
    if (Managers.Time.hour >= 23) return false;
    if (Managers.Relationship.getHeartsNum('Devin') < 3) return false;

    Managers.Time.hour = 23;
    Managers.Time.minute = 0;
    Managers.Time.seconds = 0;
    Managers.Time.updateTime();

    // //Overrides the transfer data with fixed player position for the cutscene
    $gamePlayer.reserveTransfer(mapId, 10, 20, Direction.DOWN, 0, false);
    $gameParty.removeVillager('Devin');
    $gameTemp.reserveCutscene('devin_second_date');
    return true;
  }
}

Managers.Content.registerContentClass(DevinContent);