require('game/managers/Content');

function CurupiraContent() {
}

CurupiraContent.contentId = function() {
  return 'tasks-curupira';
};

CurupiraContent.checkCutscenes = function(mapId) {
  if (this.checkCutsceneRaphaelComplainingAboutCurupira(mapId)) return true;
  if (this.checkCutsceneForestCenter1(mapId)) return true;
  if (this.checkCutsceneForestCenter2(mapId)) return true;

  return false;
};

CurupiraContent.checkCutsceneRaphaelComplainingAboutCurupira = function(mapId) {
  if (Switches.raphaelTalkedAboutForest) return false;

  if (mapId !== Maps.FARM) return false;
  if (!$gameMap.isHome()) return false;

  if (Managers.Time.hour < 6) return false;
  if (Managers.Time.hour > 12) return false;

  if (!Managers.Relationship.isCharacterKnown('Raphael')) return false;
  if (!Managers.Relationship.isCharacterKnown('Annie')) return false;
  if (!Managers.Relationship.isCharacterKnown('Chloe')) return false;

  if (Managers.Time.totalDays < 70) {
    if (Managers.Relationship.getHeartsNum('Raphael') < 0.5) return false;
    if (Managers.Relationship.getHeartsNum('Annie') < 0.5) return false;
    if (Managers.Relationship.getHeartsNum('Chloe') < 0.5) return false;
  }

  $gameTemp.reserveCutscene('raphael_talk_about_forest');
  return true;
};

CurupiraContent.checkCutsceneForestCenter1 = function(mapId) {
  if (Switches.playedRaphaelForestInvestigation) return false;
  if (!Switches.raphaelTalkedAboutForest) return false;
  if (mapId !== Maps.FOREST_CENTER) return false;
  if ($gameMap._mapId !== Maps.FOREST) return false;
  if ($gamePlayer.isRiding()) return false;

  if (!Managers.Villagers.isVillagerOnParty('Raphael')) return false;

  //Reserve the cutscene
  $gameTemp.reserveCutscene('raphael_investigating_forest');

  //Overrides the transfer data with fixed player position for the cutscene
  $gamePlayer.reserveTransfer(mapId, 2, 10, Direction.RIGHT, 0, false);

  return true;
};

CurupiraContent.checkCutsceneForestCenter2 = function(mapId) {
  if (Switches.talkedToCurupira) return false;
  if (!Switches.talkedToBenjaminAboutCurupira) return false;
  if (mapId !== Maps.FOREST_CENTER) return false;
  if ($gameMap._mapId !== Maps.FOREST) return false;
  if ($gamePlayer.isRiding()) return false;

  if (!Managers.Villagers.isVillagerOnParty('Raphael')) return false;

  //Reserve the cutscene
  $gameTemp.reserveCutscene('raphael_investigating_forest_2');

  //Overrides the transfer data with fixed player position for the cutscene
  $gamePlayer.reserveTransfer(mapId, 2, 10, Direction.RIGHT, 0, false);

  return true;
};

CurupiraContent.processNewDay = function() {
  if (!Switches.talkedToCurupira) return;

  if (Managers.Time.year > 1 || Managers.Time.month > 2) {
    if (!Switches.forestSpellLifted) {
      Switches.forestSpellLifted = true;
      Switches.needsRaphaelLetterAboutForest = true;
    }
  }
};

Managers.Content.registerContentClass(CurupiraContent);
