require('game/objects/CustomEvent');

Objects.VillagerSitting = class VillagerSitting extends Objects.CustomEvent {
  update() {
    super.update();

    this._lockPattern = true;

    if (this._animationTimeOut === undefined) {
      this._animationTimeOut = Utils.getFrameCount(10);
      return;
    }

    if (!this._animationTimeOut) {
      this.nextDanceFrame();
      return;
    }

    this._animationTimeOut--;
  }

  nextDanceFrame() {
    const frameLength = 6;

    const allFrames = [
      { index: 3, direction: 2, pattern: 0, frameLength },
      { index: 3, direction: 2, pattern: 1, frameLength },
      { index: 3, direction: 2, pattern: 2, frameLength },
      { index: 3, direction: 4, pattern: 0, frameLength },
      { index: 3, direction: 4, pattern: 1, frameLength },
      { index: 3, direction: 4, pattern: 2, frameLength },
      { index: 3, direction: 6, pattern: 0, frameLength },
      { index: 3, direction: 6, pattern: 1, frameLength },
    ];

    let currentFrame = this._currentFrame || 0;

    let nextFrame = currentFrame + 1;
    if (nextFrame >= allFrames.length) {
      nextFrame = 0;
    }

    this._currentFrame = nextFrame;
    const frameData = allFrames[nextFrame];
    this._characterIndex = frameData.index;
    this._direction = frameData.direction;
    this._pattern = frameData.pattern;

    this._animationTimeOut = Utils.getFrameCount(frameData.frameLength);
  }
};
