const Cindy = require('./Cindy');

class CindyContent {
  static contentId() {
    return 'cindy';
  }

  static isVillagerBridgesBurned(villagerName) {
    if (villagerName.toLowerCase() !== 'cindy') return;

    return Switches.burnedBridgesWithCindy;
  }

  static getCurrentSchedule(villagerName) {
    if (villagerName.toLowerCase() != 'cindy') return;

    if (Switches.cindyMovedOut) {
      if (Switches.cindyWorkingWithRaphael) {
        return 'livingWithChloe';
      }

      return 'waitingForRaphaelCutscene';
    }

    return 'default';
  }

  static checkCutscenes(mapId) {
    if ($gamePlayer.isRiding()) return false;
    if (!Managers.Relationship.isCharacterKnown('Cindy')) return false;
    if (Managers.Relationship.isVillagerBridgesBurned('Cindy')) return false;

    if (!$gameParty.hasCompanion()) {
      if (this.checkCutsceneHeartEventZero(mapId)) return true;
      if (this.checkCutsceneHeartEventOne(mapId)) return true;
      if (this.checkCutsceneNewShop(mapId)) return true;
    } else {
      if (this.checkCutsceneCindyDate1(mapId)) return true;
      if (this.checkCutsceneCindyDate2(mapId)) return true;
    }
    
    return false;
  }

  static checkCutsceneCindyDate1(mapId) {
    if (Switches.playedCindyFirstDate) return false;
    if (!Switches.playedCindyHeartEvent0) return false;
    if (!Switches.playedCindyHeartEvent1) return false;
    if (!Switches.unlockedCindyEvents) return false;

    if (mapId !== Maps.MOUNTAIN) return false;
    if ($gameMap._mapId != Maps.ORANGE_TOWN) return false;

    if (!$gameParty.isVillagerOnParty('Cindy')) return false;
    if (Managers.Time.hour < 10) return false;
    if (Managers.Time.hour >= 14) return false;
    if (Managers.Relationship.getHeartsNum('Cindy') < 2) return false;

    Managers.Time.hour = 14;
    Managers.Time.minute = 3;
    Managers.Time.seconds = 0;
    Managers.Time.updateTime();

    //Overrides the transfer data with fixed player position for the cutscene
    $gamePlayer.reserveTransfer(mapId, 70, 73, Direction.LEFT, 0, false);
    $gameParty.removeVillager('Cindy');
    $gameTemp.reserveCutscene('cindy_first_date');
    return true;
  }

  static checkCutsceneCindyDate2(mapId) {
    if (Switches.playedCindySecondDate) return false;
    if (!Switches.playedCindyFirstDate) return false;
    if (!Switches.playedCindyHeartEvent0) return false;
    if (!Switches.playedCindyHeartEvent1) return false;
    if (!Switches.unlockedCindyEvents) return false;

    if (mapId !== Maps.BEACH) return false;
    if ($gameMap._mapId != Maps.PETTING_ZOO) return false;

    if (!$gameParty.isVillagerOnParty('Cindy')) return false;
    if (Managers.Time.hour < 20) return false;
    if (Managers.Time.hour >= 23) return false;
    if (Managers.Relationship.getHeartsNum('Cindy') < 3) return false;

    Managers.Time.hour = 23;
    Managers.Time.minute = 0;
    Managers.Time.seconds = 0;
    Managers.Time.updateTime();
    Switches.hidePlayer = true;

    // //Overrides the transfer data with fixed player position for the cutscene
    $gamePlayer.reserveTransfer(mapId, 5, 13, Direction.DOWN, 0, false);
    $gameParty.removeVillager('Cindy');
    $gameTemp.reserveCutscene('cindy_second_date');
    return true;
  }

  static checkCutsceneHeartEventZero(mapId) {
    if (Switches.playedCindyHeartEvent0) return false;

    if (mapId !== Maps.RORYS_FARM) return false;

    if (!Managers.Relationship.isCharacterKnown('Raphael')) return false;
    if (!Managers.Relationship.isCharacterKnown('Rory')) return false;
    if (!Switches.unlockedCindyEvents) return false;

    //Overrides the transfer data with fixed player position for the cutscene
    $gamePlayer.reserveTransfer(mapId, 5, 9, Direction.UP, 0, false);
    $gameTemp.reserveCutscene('cindy_events_0_hearts');
    return true;
  }

  static checkCutsceneHeartEventOne(mapId) {
    if (Switches.playedCindyHeartEvent1) return false;
    if (!Switches.playedCindyHeartEvent0) return false;

    if (mapId !== Maps.RORYS_FARM) return false;

    if (!Managers.Relationship.isCharacterKnown('Raphael')) return false;
    if (!Managers.Relationship.isCharacterKnown('Viktor')) return false;
    if (!Managers.Relationship.isCharacterKnown('Rory')) return false;
    if (!Switches.unlockedCindyEvents) return false;
    if (Managers.Relationship.getHeartsNum('Cindy') < 1) return false;

    Switches.hidePlayer = true;
    //Overrides the transfer data with fixed player position for the cutscene
    $gamePlayer.reserveTransfer(mapId, 5, 10, Direction.UP, 0, false);
    $gameTemp.reserveCutscene('cindy_events_1_heart');
    return true;
  }

  static checkCutsceneNewShop(mapId) {
    if (Switches.cindyWorkingWithRaphael) return false;
    if (!Switches.cindyMovedOut) return false;

    if (mapId !== Maps.CARPENTER_HOUSE) return false;

    $gamePlayer.reserveTransfer(mapId, 11, 16, Direction.UP, 0, false);
    $gameTemp.reserveCutscene('cindy_new_shop');
    return true;
  }

  static parsePluginCommand(parser, command, args) {
    if (command.toUpperCase() !== 'CINDY') {
      return;
    }

    switch(parser.name.toUpperCase()) {
      case 'OPENDOOR':
        Cindy.openDoor();
        return true;
      case 'CLOSEDOOR':
        Cindy.closeDoor();
        return true;
      case 'CHAT':
        {
          const methods = Managers.Villagers.buildContextChatMethods('Cindy', parser.interpreter);
          Cindy.chat(methods);
        }
        return true;
    }
  }
}

Managers.Content.registerContentClass(CindyContent);