const BaseVillager = require('../_system/BaseVillager');

class Cindy extends BaseVillager {
  static getVillagerName() {
    return 'Cindy';
  }

  static validMaps() {
    return [
      Maps.RORYS_FARM,
      Maps.RESTAURANT,
      Maps.ORANGE_TOWN,
      Maps.CARPENTER_HOUSE,
      Maps.INN
    ];
  }

  static openDoor() {
    if (Switches.cindyMovedOut) {
      $gameMap.openVillagerDoor('Chloe');
    } else {
      $gameMap.openVillagerDoor('Rory');
    }
  }

  static closeDoor() {
    if (Switches.cindyMovedOut) {
      $gameMap.closeVillagerDoor('Chloe');
    } else {
      $gameMap.closeVillagerDoor('Rory');
    }
  }

  static _chatSequentialConversation(methods) {
    const { playDuringOneDayOnly } = methods;

    if (!Switches.unlockedCindyEvents) {
      if (playDuringOneDayOnly('cindy_sequential_1')) return true;
      if (playDuringOneDayOnly('cindy_sequential_2')) return true;
      if (playDuringOneDayOnly('cindy_sequential_3')) return true;
      if (playDuringOneDayOnly('cindy_sequential_4')) return true;
      if (playDuringOneDayOnly('cindy_sequential_5')) return true;
      if (playDuringOneDayOnly('cindy_sequential_6')) return true;
      if (playDuringOneDayOnly('cindy_sequential_7')) return true;
      if (playDuringOneDayOnly('cindy_sequential_8')) return true;
      if (playDuringOneDayOnly('cindy_sequential_9')) return true;
      if (playDuringOneDayOnly('cindy_sequential_10')) return true;
      Switches.unlockedCindyEvents = true;
    }

    return false;
  }

  static _chatDefaultSchedule(methods) {
    const { play, playOnePerWeekDay } = methods;

    // Asleep
    if (Managers.Time.isBetweenTimes('00:00', '07:00')) {
      return play('cindy_default');
    }

    // Inside Rory's House
    if (Managers.Time.isBetweenTimes('07:01', '07:28')) {
      //#ToDo
    }

    // Going to the library
    if (Managers.Time.isBetweenTimes('07:29', '07:50')) {
      //#ToDo
    }

    // In front of the library
    if (Managers.Time.isBetweenTimes('07:51', '09:06')) {
      //#ToDo
    }

    // Going home to work
    if (Managers.Time.isBetweenTimes('09:07', '09:26')) {
      //#ToDo
    }

    // Working
    if (Managers.Time.isBetweenTimes('09:27', '17:20')) {
      //#ToDo
    }

    // Waiting for Bonnie
    if (Managers.Time.isBetweenTimes('17:21', '19:57')) {
      //#ToDo
    }

    // With Bonnie
    if (Managers.Time.isBetweenTimes('19:58', '21:16')) {
      //#ToDo
    }

    // At home
    if (Managers.Time.isBetweenTimes('21:17', '21:53')) {
      //#ToDo
    }

    // Asleep
    if (Managers.Time.isBetweenTimes('21:54', '23:59')) {
      return play('cindy_default');
    }

    switch (Managers.Time.month) {
      case Seasons.SPRING:
        if (playOnePerWeekDay(
          [
            'cindy_spring_sunday',
            'cindy_spring_monday',
            'cindy_spring_tuesday',
            'cindy_spring_wednesday',
            'cindy_spring_thursday',
            'cindy_spring_friday',
            'cindy_spring_saturday'
          ])) {
          return;
        }
        break;
      case Seasons.SUMMER:
        break;
    }

  }

  static _chatLivingWithChloeSchedule(methods) {
    const { play } = methods;

    // Asleep
    if (Managers.Time.isBetweenTimes('00:00', '07:00')) {
      return play('cindy_default');
    }

    // Inside the restaurant
    if (Managers.Time.isBetweenTimes('07:01', '07:28')) {
      //#ToDo
    }

    // Going to the library
    if (Managers.Time.isBetweenTimes('07:29', '07:55')) {
      //#ToDo
    }

    // In front of the library
    if (Managers.Time.isBetweenTimes('07:56', '09:06')) {
      //#ToDo
    }

    // Going and staying at the fire pit
    if (Managers.Time.isBetweenTimes('09:07', '10:00')) {
      //#ToDo
    }

    // Going back to the restaurant
    if (Managers.Time.isBetweenTimes('10:01', '10:33')) {
      //#ToDo
    }

    // Inside the restaurant
    if (Managers.Time.isBetweenTimes('10:34', '11:24')) {
      //#ToDo
    }

    // Going to work on raphael's house
    if (Managers.Time.isBetweenTimes('11:25', '12:22')) {
      //#ToDo
    }

    // Working on Raphael's House
    if (Managers.Time.isBetweenTimes('12:23', '18:24')) {
      //#ToDo
    }

    // Going to meet Bonnie, or waiting for her
    if (Managers.Time.isBetweenTimes('18:25', '19:57')) {
      //#ToDo
    }

    // With Bonnie
    if (Managers.Time.isBetweenTimes('19:58', '21:08')) {
      //#ToDo
    }

    // Going back to the restaurant
    if (Managers.Time.isBetweenTimes('21:09', '21:33')) {
      //#ToDo
    }

    // At home
    if (Managers.Time.isBetweenTimes('21:34', '21:53')) {
      //#ToDo
    }

    // Asleep
    if (Managers.Time.isBetweenTimes('21:54', '23:59')) {
      return play('cindy_default');
    }
  }

  static _chatDisabledSchedule(methods) {
    const { play } = methods;
    return play('cindy_default');
  }

  static chat(methods) {
    const { play } = methods;
    // #ToDo: Companion

    if (Cindy._chatSequentialConversation(methods)) return;

    const schedule = Managers.Villagers.getCurrentSchedule('Cindy');
    const chatFn = {
      livingWithChloe: Cindy._chatLivingWithChloeSchedule,
      waitingForRaphaelCutscene: Cindy._chatDisabledSchedule,
      default: Cindy._chatDefaultSchedule,
    }[schedule] || Cindy._chatDefaultSchedule;

    if (chatFn(methods)) {
      return true;
    }

    return play('cindy_default');
  }
}

Cindy.register();
module.exports = Cindy;
