const Chloe = require('./Chloe');

class ChloeContent {
  static contentId() {
    return 'chloe';
  }

  static parsePluginCommand(parser, command, args) {
    if (command.toUpperCase() !== 'CHLOE') {
      return;
    }

    switch(parser.name.toUpperCase()) {
      case 'OPENDOOR':
        Chloe.openDoor();
        return true;
      case 'CLOSEDOOR':
        Chloe.closeDoor();
        return true;
      case 'CHAT':
        {
          const methods = Managers.Villagers.buildContextChatMethods('Chloe', parser.interpreter);
          Chloe.chat(methods);
        }
        return true;
    }
  }

  static isVillagerAvailableToHangOut(villagerName) {
    if (villagerName !== 'Chloe') return;

    return false;
  }

  static getCurrentSchedule(villagerName) {
    if (villagerName.toLowerCase() != 'chloe') return;

    if (Managers.Weather.isBadWeather()) {
      return 'raining';
    }
  }  
}

Managers.Content.registerContentClass(ChloeContent);