const BaseVillager = require('../_system/BaseVillager');

class Chloe extends BaseVillager {
  static getVillagerName() {
    return 'Chloe';
  }

  static validMaps() {
    return [
      Maps.RESTAURANT,
      Maps.ORANGE_TOWN
    ];
  }

  static _chatSequentialConversation(methods) {
    const { playDuringOneDayOnly } = methods;

    if (!Switches.canShowChloeFoodBurntEvent) {
      if (playDuringOneDayOnly('chloe_sequential_1')) return true;
      if (playDuringOneDayOnly('chloe_sequential_2')) return true;
      if (playDuringOneDayOnly('chloe_sequential_3')) return true;
      if (playDuringOneDayOnly('chloe_sequential_4')) return true;
      if (playDuringOneDayOnly('chloe_sequential_5')) return true;
      Switches.canShowChloeFoodBurntEvent = true;
    }
    return false;
  }

  static chat(methods) {
    const { play, playOneDayPerWeek, playOnePerWeekDay } = methods;

    if (Managers.Time.yearDay === Festivals.CANDY - 1) {
      return play('chloe_candy_day_tomorrow');
    }

    if (Managers.Time.yearDay === Festivals.CANDY) {
      return play('chloe_candy_day');
    }

    if (Chloe._chatSequentialConversation(methods)) {
      return true;
    }

    // Asleep
    if (Managers.Time.isBetweenTimes('00:00', '06:45')) {
      return play('chloe_default');
    }

    // About to leave
    // if (Managers.Time.isBetweenTimes('06:46', '06:58')) {
    //   // #ToDo: change? You won't be able to talk to her at this time once I remove the restaurant door knocking
    //   return play('chloe_default');
    // }

    // Outside
    if (!Managers.Weather.isBadWeather() && Managers.Time.isBetweenTimes('06:59', '09:42')) {
      const chatList = [
      ];

      if (Managers.Time.totalDays > 31 && Managers.Relationship.getHeartsNum('Chloe') < 2) {
        chatList.push('chloe_you_lived_here_a_while');
      }
      
      chatList.push('chloe_morning_1');
      if (Managers.Time.month === Seasons.FALL) {
        chatList.push('chloe_morning_2');
      }

      // for (let i = 1; i <= 7; i++) {
      //   chatList.push(`chloe_morning_${ i }`);
      // }

      if (playOneDayPerWeek(chatList)) {
        return true;
      }
    }

    // Working
    if (Managers.Time.isBetweenTimes('09:43', '23:59')) {
      if (Managers.Health.staminaLevel <= 25 || Managers.Health.fatigueLevel >= 75) {
        return play('chloe_lowstam');
      }

      // const chatList = [
      // ];

      // for (let i = 1; i <= 7; i++) {
      //   chatList.push(`chloe_working_${ i }`);
      // }

      // if (playOneDayPerWeek(chatList)) {
      //   return true;
      // }
    }

    if (playOnePerWeekDay(
      [
        'chloe_weekly_sunday',
        'chloe_weekly_monday',
        'chloe_weekly_tuesday',
        'chloe_weekly_wednesday',
        'chloe_weekly_thursday',
        false,
        false
      ])) {
      return;
    }

    return play('chloe_default');
  }
}

Chloe.register();
module.exports = Chloe;
