const Brittany = require('./Brittany');

class BrittanyContent {
  static contentId() {
    return 'brittany';
  }

  static parsePluginCommand(parser, command, args) {
    if (command.toUpperCase() !== 'BRITTANY') {
      return;
    }

    switch(parser.name.toUpperCase()) {
      case 'OPENDOOR':
        Brittany.openDoor();
        return true;
      case 'CLOSEDOOR':
        Brittany.closeDoor();
        return true;
      case 'CHAT':
        {
          const methods = Managers.Villagers.buildContextChatMethods('Brittany', parser.interpreter);
          Brittany.chat(methods);
        }
        return true;
    }
  }

  static isVillagerAvailableToHangOut(villagerName) {
    if (villagerName !== 'Brittany') return;

    return true;
  }

  static checkCutscenes(mapId) {
    if ($gamePlayer.isRiding()) return false;
    if (!Managers.Relationship.isCharacterKnown('Brittany')) return false;

    if (this.checkCutsceneFirstTurtle(mapId)) return true;
    if (this.checkCutsceneBrittanyDate1(mapId)) return true;
    if (this.checkCutsceneBrittanyDate2(mapId)) return true;

    return false;
  }

  //----------------------------------------------------
  //---- OWN METHODS
  //----------------------------------------------------

  static checkCutsceneFirstTurtle(mapId) {
    if (Switches.playedCutsceneFirstTurtle) return false;
    if (mapId !== Maps.ORANGE_TOWN) return false;
    if ($gamePlayer.isRiding()) return false;

    if (!Managers.Time.isBetweenTimes('08:10', '09:40')) return false;

    // if (Managers.Items.isHoldingItem()) return false;

    if (!Managers.Relationship.isCharacterKnown('Brittany')) return false;
    if (!Managers.Relationship.isCharacterKnown('Nathalia')) return false;

    //Reserve the cutscene
    // $gameTemp.reserveCutscene('brittany_cutscene_first_turtle');

    return false;
    // return true;
  }

  static checkCutsceneBrittanyDate1(mapId) {
    if (Switches.playedBrittanyFirstDate) return false;
    
    if (mapId !== Maps.RESTAURANT) return false;
    if ($gameMap._mapId != Maps.ORANGE_TOWN) return false;

    if (Managers.Time.weekDay < Days.FRIDAY || Managers.Time.weekDay > Days.SATURDAY) return false;

    if (!$gameParty.isVillagerOnParty('Brittany')) return false;
    if (Managers.Time.hour < 17) return false;
    if (Managers.Time.hour >= 20) return false;
    if (Managers.Relationship.getHeartsNum('Brittany') < 2) return false;

    Managers.Time.hour = 20;
    Managers.Time.minute = 3;
    Managers.Time.seconds = 0;
    Managers.Time.updateTime();

    //Overrides the transfer data with fixed player position for the cutscene
    $gamePlayer.reserveTransfer(mapId, 15, 12, Direction.RIGHT, 0, false);
    $gameParty.removeVillager('Brittany');
    $gameTemp.reserveCutscene('brittany_first_date');
    return true;
  }

  static checkCutsceneBrittanyDate2(mapId) {
    if (Switches.playedBrittanySecondDate) return false;
    if (!Switches.playedBrittanyFirstDate) return false;

    if (mapId !== Maps.FOREST) return false;
    if ($gameMap._mapId != Maps.ORANGE_TOWN) return false;

    if (!$gameParty.isVillagerOnParty('Brittany')) return false;
    if (Managers.Time.hour < 13) return false;
    if (Managers.Time.hour >= 18) return false;
    if (Managers.Relationship.getHeartsNum('Brittany') < 3) return false;

    //Overrides the transfer data with fixed player position for the cutscene
    $gamePlayer.reserveTransfer(mapId, 4, 62, Direction.LEFT, 0, false);
    $gameParty.removeVillager('Brittany');
    $gameTemp.reserveCutscene('brittany_second_date');
    return true;
  }
}

Managers.Content.registerContentClass(BrittanyContent);
