const BaseVillager = require('../_system/BaseVillager');

class Brittany extends BaseVillager {
  static getVillagerName() {
    return 'Brittany';
  }

  static validMaps() {
    return [
      Maps.BRITTANYS_FARM,
      Maps.ORANGE_TOWN,
      Maps.GENERAL_STORE
    ];
  }

  static _chatSequentialConversation(methods) {
    const { playDuringOneDayOnly } = methods;

    if (!Switches.unlockedBrittanyEvents) {
      if (playDuringOneDayOnly('brittany_sequential_1')) return true;
      if (playDuringOneDayOnly('brittany_sequential_2')) return true;
      if (playDuringOneDayOnly('brittany_sequential_3')) return true;
      if (playDuringOneDayOnly('brittany_sequential_4')) return true;
      if (playDuringOneDayOnly('brittany_sequential_5')) return true;
      if (playDuringOneDayOnly('brittany_sequential_6')) return true;
      if (playDuringOneDayOnly('brittany_sequential_7')) return true;
      if (playDuringOneDayOnly('brittany_sequential_8')) return true;
      if (playDuringOneDayOnly('brittany_sequential_9')) return true;
      if (playDuringOneDayOnly('brittany_sequential_10')) return true;

      Switches.unlockedBrittanyEvents = true;
    }

    return false;
  }

  static chat(methods) {
    const { play, playOnePerWeekDay } = methods;
    // #ToDo: Companion

    if (Managers.Time.yearDay === Festivals.CANDY) {
      return play('brittany_candy_day');
    }

    if (Brittany._chatSequentialConversation(methods)) {
      return true;
    }

    // Asleep
    if (Managers.Time.isBetweenTimes('00:00', '07:09')) {
      return play('brittany_default');
    }

    // At home
    // if (Managers.Time.isBetweenTimes('07:10', '08:40')) {
    //   if (playOneDayPerWeek(
    //     [
    //       'brittany_early_morning_1',
    //       'brittany_early_morning_2',
    //       'brittany_early_morning_3',
    //     ])) {
    //     return true;
    //   }
    // }

    // Outside
    // if (Managers.Time.isBetweenTimes('08:41', '11:55')) {
    //   if (playOneDayPerWeek(
    //     [
    //       'brittany_outside_1',
    //       'brittany_outside_2',
    //       'brittany_outside_3',
    //     ])) {
    //     return true;
    //   }
    // }

    // At home
    // if (Managers.Time.isBetweenTimes('11:56', '14:21')) {
    //   if (playOneDayPerWeek(
    //     [
    //       'brittany_lunch_1',
    //       'brittany_lunch_2',
    //       'brittany_lunch_3',
    //     ])) {
    //     return true;
    //   }
    // }

    // Going to the store
    // if (Managers.Time.isBetweenTimes('14:22', '15:16')) {
    //   if (playOneDayPerWeek(
    //     [
    //       'brittany_going_to_store_1',
    //       'brittany_going_to_store_2',
    //       'brittany_going_to_store_3',
    //     ])) {
    //     return true;
    //   }
    // }

    // In the store
    // if (Managers.Time.isBetweenTimes('15:17', '15:48')) {
    //   if (playOneDayPerWeek(
    //     [
    //       'brittany_in_the_store_1',
    //       'brittany_in_the_store_2',
    //       'brittany_in_the_store_3',
    //     ])) {
    //     return true;
    //   }
    // }

    // Going back home
    // if (Managers.Time.isBetweenTimes('15:49', '16:41')) {
    //   if (playOneDayPerWeek(
    //     [
    //       'brittany_going_back_home_1',
    //       'brittany_going_back_home_2',
    //       'brittany_going_back_home_3',
    //     ])) {
    //     return true;
    //   }
    // }

    // At home doing nothing
    // if (Managers.Time.isBetweenTimes('16:42', '19:51')) {
    //   if (playOneDayPerWeek(
    //     [
    //       'brittany_evening_1',
    //       'brittany_evening_2',
    //       'brittany_evening_3',
    //     ])) {
    //     return true;
    //   }
    // }

    if (playOnePerWeekDay(
      [
        'brittany_weekly_sunday',
        'brittany_weekly_monday',
        'brittany_weekly_tuesday',
        'brittany_weekly_wednesday',
        'brittany_weekly_thursday',
        'brittany_weekly_friday',
        'brittany_weekly_saturday'
      ])) {
      return;
    }

    if (Managers.Time.day % 2 === 1 && $gameMap._mapId === Maps.BRITTANYS_FARM) {
      return play('brittany_1');
    }

    return play('brittany_default');
  }
}

Brittany.register();

module.exports = Brittany;
