const Bonnie = require('./Bonnie');

class BonnieContent {
  static contentId() {
    return 'bonnie';
  }

  static parsePluginCommand(parser, command, args) {
    if (command.toUpperCase() !== 'BONNIE') {
      return;
    }

    switch(parser.name.toUpperCase()) {
      case 'OPENDOOR':
        Bonnie.openDoor();
        return true;
      case 'CLOSEDOOR':
        Bonnie.closeDoor();
        return true;
      case 'CHAT':
        {
          const methods = Managers.Villagers.buildContextChatMethods('Bonnie', parser.interpreter);
          Bonnie.chat(methods);
        }
        return true;
    }
  }

  static isVillagerAvailableToHangOut(villagerName) {
    if (villagerName !== 'Bonnie') return;

    return false;
  }
}

Managers.Content.registerContentClass(BonnieContent);