const BaseVillager = require('../_system/BaseVillager');

class Bonnie extends BaseVillager {
  static getVillagerName() {
    return 'Bonnie';
  }

  static validMaps() {
    return [
      Maps.CLINIC,
      Maps.ORANGE_TOWN
    ];
  }

  static chat(methods) {
    const { play, playOnePerWeekDay, playOneDayPerWeek } = methods;
    // #ToDo: Companion

    if (Managers.Time.yearDay === Festivals.CANDY - 1) {
      return play('bonnie_candy_day_tomorrow');
    }

    if (Managers.Time.yearDay === Festivals.CANDY) {
      return play('bonnie_candy_day');
    }

    // Asleep
    if (Managers.Time.isBetweenTimes('00:00', '06:37')) {
      return play('bonnie_default');
    }

    // Still at home
    if (Managers.Time.isBetweenTimes('06:38', '07:00')) {
      if (playOneDayPerWeek(
        [
          'bonnie_early_morning_1',
          // 'bonnie_early_morning_2',
          // 'bonnie_early_morning_3',
        ])) {
        return true;
      }
    }

    // Going to the library
    // if (Managers.Time.isBetweenTimes('07:01', '07:41')) {
    //   if (playOneDayPerWeek(
    //     [
    //       'bonnie_going_to_library_1',
    //       'bonnie_going_to_library_2',
    //       'bonnie_going_to_library_3',
    //     ])) {
    //     return true;
    //   }
    // }

    // Standing by the library
    // if (Managers.Time.isBetweenTimes('07:42', '09:06')) {
    //   if (playOneDayPerWeek(
    //     [
    //       'bonnie_standing_by_the_library_1',
    //       'bonnie_standing_by_the_library_2',
    //       'bonnie_standing_by_the_library_3',
    //     ])) {
    //     return true;
    //   }
    // }

    // Going to the clinic
    // if (Managers.Time.isBetweenTimes('09:07', '09:47')) {
    //   if (playOneDayPerWeek(
    //     [
    //       'bonnie_going_back_to_clinic_1',
    //       'bonnie_going_back_to_clinic_2',
    //       'bonnie_going_back_to_clinic_3',
    //     ])) {
    //     return true;
    //   }
    // }

    // At work
    // if (Managers.Time.isBetweenTimes('09:48', '19:20')) {
    //   if (playOneDayPerWeek(
    //     [
    //       'bonnie_at_work_1',
    //       'bonnie_at_work_2',
    //       'bonnie_at_work_3',
    //     ])) {
    //     return true;
    //   }
    // }

    // Going to meet with Cindy again
    // if (Managers.Time.isBetweenTimes('19:21', '19:57')) {
    //   if (playOneDayPerWeek(
    //     [
    //       'bonnie_going_out_at_night_1',
    //       'bonnie_going_out_at_night_2',
    //       'bonnie_going_out_at_night_3',
    //     ])) {
    //     return true;
    //   }
    // }

    // Standing in the benches
    // if (Managers.Time.isBetweenTimes('19:58', '22:02')) {
    //   if (playOneDayPerWeek(
    //     [
    //       'bonnie_standing_in_benches_1',
    //       'bonnie_standing_in_benches_2',
    //       'bonnie_standing_in_benches_3',
    //     ])) {
    //     return true;
    //   }
    // }

    // Going back home
    // if (Managers.Time.isBetweenTimes('22:03', '22:40')) {
    //   if (playOneDayPerWeek(
    //     [
    //       'bonnie_going_back_home_1',
    //       'bonnie_going_back_home_2',
    //       'bonnie_going_back_home_3',
    //     ])) {
    //     return true;
    //   }
    // }

    // About to go to bed
    // if (Managers.Time.isBetweenTimes('22:41', '22:48')) {
    //   return play('bonnie_about_to_go_to_bed');
    // }

    if (playOnePerWeekDay(
      [
        'bonnie_weekly_sunday',
        'bonnie_weekly_monday',
        'bonnie_weekly_tuesday',
        'bonnie_weekly_wednesday',
        'bonnie_weekly_thursday',
        'bonnie_weekly_friday',
        'bonnie_weekly_saturday'
      ])) {
      return;
    }

    return play('bonnie_default');
  }
}

Bonnie.register();

module.exports = Bonnie;
