const Billy = require('./Billy');

class BillyContent {
  static contentId() {
    return 'billy';
  }

  static parsePluginCommand(parser, command, args) {
    if (command.toUpperCase() !== 'BILLY') {
      return;
    }

    switch(parser.name.toUpperCase()) {
      case 'OPENDOOR':
        Billy.openDoor();
        return true;
      case 'CLOSEDOOR':
        Billy.closeDoor();
        return true;
      case 'CHAT':
        {
          const methods = Managers.Villagers.buildContextChatMethods('Billy', parser.interpreter);
          Billy.chat(methods);
        }
        return true;
    }
  }
}

Managers.Content.registerContentClass(BillyContent);