const BaseVillager = require('../_system/BaseVillager');

class Billy extends BaseVillager {
  static getVillagerName() {
    return 'Billy';
  }

  static validMaps() {
    return [
      Maps.RORYS_FARM,
      Maps.ORANGE_TOWN
    ];
  }

  static openDoor() {
    $gameMap.openVillagerDoor('Rory');
  }

  static closeDoor() {
    $gameMap.closeVillagerDoor('Rory');
  }

  static chat(methods) {
    const { play, playOnePerWeekDay, playOneDayPerMonth } = methods;
    // #ToDo: Companion

    if (Switches.builtSecondFloor){
      if (playOneDayPerMonth('billy_house_second_floor')) return;
    } else if (Switches.expandedHouse) {
      if (playOneDayPerMonth('billy_house_expansion')) return;
    }

    if (Managers.Time.month === Seasons.SPRING) {
      if (playOnePerWeekDay(
        [
          'billy_spring_sunday',
          'billy_spring_monday',
          'billy_spring_tuesday',
          'billy_spring_wednesday',
          'billy_spring_thursday',
          'billy_spring_friday',
          'billy_spring_saturday'
        ])) {
        return;
      }
    }

    return play('billy_default');
  }
}

Billy.register();

module.exports = Billy;