const Benjamin = require('./Benjamin');

class BenjaminContent {
  static contentId() {
    return 'benjamin';
  }

  static parsePluginCommand(parser, command, args) {
    if (command.toUpperCase() !== 'BENJAMIN') {
      return;
    }

    switch(parser.name.toUpperCase()) {
      case 'OPENDOOR':
        Benjamin.openDoor();
        return true;
      case 'CLOSEDOOR':
        Benjamin.closeDoor();
        return true;
      case 'CHAT':
        {
          const methods = Managers.Villagers.buildContextChatMethods('Benjamin', parser.interpreter);
          Benjamin.chat(methods);
        }
        return true;
    }
  }

  static isVillagerAvailableToHangOut(villagerName) {
    if (villagerName !== 'Benjamin') return;

    return true;
  }

  static checkCutscenes(mapId) {
    if ($gamePlayer.isRiding()) return false;
    if (!Managers.Relationship.isCharacterKnown('Benjamin')) return false;


    if (this.checkBenjaminMakingHayCutscene(mapId)) return true;
    if (this.checkCutsceneBenjaminHeartEvent0(mapId)) return true;

    if (this.checkCutsceneBenjaminDate1(mapId)) return true;
    if (this.checkCutsceneBenjaminDate2(mapId)) return true;

    return false;
  }




  static checkCutsceneBenjaminDate1(mapId) {
    if (Switches.playedBenjaminFirstDate) return false;
    if (!Switches.playedBenjaminHeartEvent0) return false;
    if (!Switches.benjaminOpenedUp) return false;

    if (mapId !== Maps.MOUNTAIN) return false;
    if ($gameMap._mapId != Maps.ORANGE_TOWN) return false;

    if (!$gameParty.isVillagerOnParty('Benjamin')) return false;
    if (Managers.Time.hour < 10) return false;
    if (Managers.Time.hour >= 14) return false;
    if (Managers.Relationship.getHeartsNum('Benjamin') < 2) return false;

    Managers.Time.hour = 14;
    Managers.Time.minute = 3;
    Managers.Time.seconds = 0;
    Managers.Time.updateTime();

    //Overrides the transfer data with fixed player position for the cutscene
    $gamePlayer.reserveTransfer(mapId, 70, 73, Direction.LEFT, 0, false);
    $gameParty.removeVillager('Benjamin');
    $gameTemp.reserveCutscene('benjamin_first_date');
    return true;
  }

  static checkCutsceneBenjaminDate2(mapId) {
    if (Switches.playedBenjaminSecondDate) return false;
    if (!Switches.playedBenjaminFirstDate) return false;
    if (!Switches.playedBenjaminHeartEvent0) return false;
    if (!Switches.benjaminOpenedUp) return false;

    if (mapId !== Maps.FOREST) return false;
    if ($gameMap._mapId != Maps.ORANGE_TOWN) return false;

    if (!$gameParty.isVillagerOnParty('Benjamin')) return false;
    if (Managers.Time.hour < 13) return false;
    if (Managers.Time.hour >= 18) return false;
    if (Managers.Relationship.getHeartsNum('Benjamin') < 3) return false;

    //Overrides the transfer data with fixed player position for the cutscene
    $gamePlayer.reserveTransfer(mapId, 4, 62, Direction.LEFT, 0, false);
    $gameParty.removeVillager('Benjamin');
    $gameTemp.reserveCutscene('benjamin_second_date');
    return true;
  }

  static checkBenjaminMakingHayCutscene(mapId) {
    if (mapId !== Maps.FARM) return false;
    if (Managers.Time.hour < 6) return false;
    if (Managers.Time.hour >= 12) return false;
    if (Managers.Time.yearDay < 10) return false;
    if (!Switches.unlockedBenjiHayTask) return false;
    if (Managers.Tasks.isTaskKnown('benjamin-making-hay')) return false;

    if (!$gameMap.isHome()) return false;
    if ($gameTemp.isCutsceneReserved()) return false;

    $gameTemp.reserveCutscene('benjamin_offer_to_make_hay');
    return true;
  }

  static checkCutsceneBenjaminHeartEvent0(mapId) {
    if (Switches.playedBenjaminHeartEvent0) return false;

    if (mapId !== Maps.RESTAURANT) return false;
    if (Managers.Time.hour < 11) return false;
    if (Managers.Time.hour >= 15) return false;
    if (!Switches.benjaminOpenedUp) return false;
    if (!Switches.unlockedNathaliaEvents) return false;

    if (Managers.Relationship.getHeartsNum('Nathalia') < 0.5) return false;
    if (Managers.Relationship.getHeartsNum('Benjamin') < 0.5) return false;

    if ($gameMap._mapId !== Maps.ORANGE_TOWN) return false;
    if ($gameParty.hasCompanion()) return false;

    Switches.hidePlayer = true;
    $gamePlayer.reserveTransfer(mapId, 10.5, 18, Direction.UP, 0, false);
    $gameTemp.reserveCutscene('benjamin_heart_event_0');
    return true;
  }
}

Managers.Content.registerContentClass(BenjaminContent);