const BaseVillager = require('../_system/BaseVillager');

class Benjamin extends BaseVillager {
  static getVillagerName() {
    return 'Benjamin';
  }

  static validMaps() {
    return [
      Maps.BENJAMINS_HOUSE,
      Maps.ORANGE_TOWN,
      Maps.GENERAL_STORE,
      Maps.RESTAURANT,
      Maps.BRITTANYS_FARM,
      Maps.ILDAS_HOUSE
    ];
  }

  static checkIfVillagerShouldLeaveParty() {
    if (Managers.Time.isBetweenTimes('23:45', '23:59') || Managers.Time.isBetweenTimes('00:00', '06:59')) {
      Managers.CommonEvent.playEvent('benjamin_leave_party_to_sleep');
      return;
    }
  }

  static _chatSequentialConversation(methods) {
    const { playDuringOneDayOnly } = methods;

    if (!Switches.benjaminOpenedUp) {
      if (playDuringOneDayOnly('benjamin_hints_1')) return true;
      if (!Switches.hasIronHammer) {
        if (playDuringOneDayOnly('benjamin_hints_2')) return true;
      }
      if (playDuringOneDayOnly('benjamin_hints_3')) return true;
      
      Switches.unlockedBenjiHayTask = true;
      if (playDuringOneDayOnly('benjamin_hints_4')) return true;
      if (playDuringOneDayOnly('benjamin_hints_5')) return true;
      if (playDuringOneDayOnly('benjamin_hints_6')) return true;
      if (playDuringOneDayOnly('benjamin_hints_7')) return true;
      if (playDuringOneDayOnly('benjamin_hints_8')) return true;
      if (playDuringOneDayOnly('benjamin_movies_1')) return true;
      Switches.benjaminOpenedUp = true;
    }

    return false;
  }

  static chat(methods) {
    const { play, playOnceADay, playOneDayPerWeek, playOncePerYear, playDuringOneDayOnly, playOneDayPerMonth, playOnePerWeekDay } = methods;
    // #ToDo: Companion

    // Wakes up at 07:10
    // Leaves house at 09:25
    // Enters store at 10:25
    // Leaves store at 11:18
    // Enters clinic at 12:27
    // Leaves clinic at 13:45
    // Enters house at 14:15
    // Sleeps at 23:44

    // #ToDo: Make him wander a bit more in the evening
    // #ToDo: Make Brittany visit him in the afternoon

    if (Benjamin._chatSequentialConversation(methods)) {
      return true;
    }

    if (Managers.Time.isBetweenTimes('00:00', '07:09')) {
      // He's actually asleep at this time, so something went wrong anyway
      return play('benjamin_default');
    }

    if (Managers.Time.yearDay == Festivals.CANDY - 1) {
      if (playOnceADay('benjamin_candy_day_tomorrow')) return;
    }

    if (Switches.isCandyFestival) {
      return play('benjamin_candy_day');
    }

    // In his house
    if (Managers.Time.isBetweenTimes('07:10', '09:24')) {
      return play('benjamin_weekly_mornings');
    }

    // Going to the store
    if (Managers.Time.isBetweenTimes('09:25', '10:33')) {
      return play('benjamin_weekly_mornings');
    }

    // In the store
    if (Managers.Time.isBetweenTimes('10:34', '11:17')) {
      if (Managers.Time.weekDay === Days.SATURDAY) {
        return play('benjamin_talk_about_salesman');
      }
    }

    // Going to Brittany's House
    if (Managers.Time.isBetweenTimes('11:18', '12:12')) {
      if (Managers.Time.month === Seasons.SPRING) {
        if (playOncePerYear('benjamin_picking_flowers')) return;
      }

      if (Managers.Time.day >= 20) {
        if (playOneDayPerMonth('benjamin_talk_about_sisters_2')) return;
      }

      if (playOnePerWeekDay([
        false,
        false,
        'benjamin_talk_about_sisters_1',
        'benjamin_talk_about_sisters_3',
        'benjamin_talk_about_sisters_4',
        false,
        false,
      ])) return;

      if (playOneDayPerMonth('benjamin_comment_julia_prize')) return;
    }

    // In Brittany's House
    if (Managers.Time.isBetweenTimes('12:13', '14:15')) {
      //#ToDo
    }

    // Going to Ilda's House

    // Going home
    if (Managers.Time.isBetweenTimes('13:45', '14:14')) {
      if (Managers.Time.yearDay <= 7 && Managers.Time.weekDay === Days.FRIDAY) {
        return play('benjamin_first_friday');
      }

      if (Switches.benjaminOpenedUp) {
        if (playOneDayPerWeek('benjamin_movies_2')) return;
      }

      if (playOneDayPerWeek('benjamin_expecting_brittany')) return;
    }

    // Home
    if (Managers.Time.isBetweenTimes('14:15', '23:44')) {

      // When Brittany is with him #ToDo
      if (Managers.Time.isBetweenTimes('16:00', '17:00')) {
        if (Switches.benjaminOpenedUp) {
          if (playOneDayPerWeek('benjamin_comment_about_brittanys_visit')) return;
        }

      } else {

        if (Managers.Time.isBetweenTimes('17:01', '18:59')) {
          if (Switches.benjaminOpenedUp) {
            if (Managers.Time.weekDay === Days.FRIDAY) {
              if (playDuringOneDayOnly('benjamin_late_friday_drinking_1')) return;
              return play('benjamin_late_friday_drinking_2');
            }
          }
        }
      }

    }

    // Asleep
    if (Managers.Time.isBetweenTimes('23:45', '23:59')) {
      return play('benjamin_default');
    }

    return play('benjamin_default');
  }
}

Benjamin.register();

module.exports = Benjamin;