const Annie = require('./Annie');

class AnnieContent {
  static contentId() {
    return 'annie';
  }

  static parsePluginCommand(parser, command, args) {
    if (command.toUpperCase() !== 'ANNIE') {
      return;
    }

    switch(parser.name.toUpperCase()) {
      case 'OPENDOOR':
        Annie.openDoor();
        return true;
      case 'CLOSEDOOR':
        Annie.closeDoor();
        return true;
      case 'CHAT':
        {
          const methods = Managers.Villagers.buildContextChatMethods('Annie', parser.interpreter);
          Annie.chat(methods);
        }
        return true;
    }
  }

  static isVillagerAvailableToHangOut(villagerName) {
    if (villagerName !== 'Annie') return;

    return true;
  }

  static getCurrentSchedule(villagerName) {
    if (villagerName.toLowerCase() != 'annie') return;

    if (Managers.Weather.isBadWeather()) {
      return 'raining';
    }
  }

  static checkCutscenes(mapId) {
    if ($gamePlayer.isRiding()) return false;
    if (!Managers.Relationship.isCharacterKnown('Annie')) {
      return this.checkCutsceneAnnieIntroduction(mapId);
    }

    if (!$gameParty.hasCompanion()) {
      if (this.checkCutsceneAnnieZeroHearts(mapId)) return true;
      if (this.checkCutsceneAnnieOneHearts(mapId)) return true;

      this.checkEventPhisShenanigans();
    } else {
      if (this.checkCutsceneAnnieDate1(mapId)) return true;
      if (this.checkCutsceneAnnieDate2(mapId)) return true;
    }
    
    return false;
  }

  static checkCutsceneAnnieDate1(mapId) {
    if (Switches.playedAnnieFirstDate) return false;
    if (!Switches.playedAnnieFirstHeart) return false;

    if (mapId !== Maps.MOUNTAIN) return false;
    if ($gameMap._mapId != Maps.ORANGE_TOWN) return false;

    if (!$gameParty.isVillagerOnParty('Annie')) return false;
    if (Managers.Time.hour < 10) return false;
    if (Managers.Time.hour >= 14) return false;
    if (Managers.Relationship.getHeartsNum('Annie') < 2) return false;

    Managers.Time.hour = 14;
    Managers.Time.minute = 3;
    Managers.Time.seconds = 0;
    Managers.Time.updateTime();

    //Overrides the transfer data with fixed player position for the cutscene
    $gamePlayer.reserveTransfer(mapId, 66, 73, Direction.LEFT, 0, false);
    $gameParty.removeVillager('Annie');
    $gameTemp.reserveCutscene('annie_first_date');
    return true;
  }

  static checkCutsceneAnnieDate2(mapId) {
    if (Switches.playedAnnieSecondDate) return false;
    if (!Switches.playedAnnieFirstDate) return false;

    if (mapId !== Maps.FOREST) return false;
    if ($gameMap._mapId != Maps.ORANGE_TOWN) return false;

    if (!$gameParty.isVillagerOnParty('Annie')) return false;
    if (Managers.Time.hour < 13) return false;
    if (Managers.Time.hour >= 18) return false;
    if (Managers.Relationship.getHeartsNum('Annie') < 3) return false;

    //Overrides the transfer data with fixed player position for the cutscene
    $gamePlayer.reserveTransfer(mapId, 4, 62, Direction.LEFT, 0, false);
    $gameParty.removeVillager('Annie');
    $gameTemp.reserveCutscene('annie_second_date');
    return true;
  }



  static checkCutsceneAnnieIntroduction(mapId) {
    if (Switches.playedAnnieIntroduction) return false;
    if (mapId !== Maps.FOREST_CENTER) return false;
    if ($gameMap._mapId !== Maps.FOREST) return false;
    if ($gamePlayer.isRiding()) return false;
    if ($gameParty.hasCompanion()) return false;
    if ($gameSystem.isCharacterKnown('Annie')) return false;

    //Reserve the cutscene
    $gameTemp.reserveCutscene('annie_introduction_scene');

    //Overrides the transfer data with fixed player position for the cutscene
    $gamePlayer.reserveTransfer(mapId, 1, 10, Direction.RIGHT, 0, false);

    return true;
  }

  static checkCutsceneAnnieZeroHearts(mapId) {
    if (Switches.playedAnnieZeroHearts) return false;
    if (mapId != Maps.ORANGE_TOWN) return false;
    if ($gameMap.isInside()) return false;
    if ($gamePlayer.isRiding()) return false;
    if ($gameMap._mapId == Maps.ORANGE_TOWN) return false;

    if (!Managers.Time.isBetweenTimes('10:00', '12:30')) return false;
    if (Managers.Weather.isBadWeather()) return false;

    if (Managers.Relationship.getHeartsNum('Annie') < 0.5) return false;

    $gameTemp.reserveCutscene('annie_heart_event_zero');

    $gamePlayer.backupTransferPosition();
    $gamePlayer.reserveTransfer(mapId, 17, 39, Direction.DOWN, 0, false);
    Switches.hidePlayer = true;

    return true;
  }

  static checkCutsceneAnnieOneHearts(mapId) {
    if (Switches.playedAnnieFirstHeart) return false;
    if (!Switches.playedAnnieZeroHearts) return false;
    if (mapId != Maps.RESTAURANT) return false;
    if ($gameMap._mapId != Maps.ORANGE_TOWN) return false;
    if ($gamePlayer.isRiding()) return false;

    if (!Managers.Time.isBetweenTimes('12:51', '15:17')) return false;
    if (Managers.Relationship.getHeartsNum('Annie') < 1) return false;

    $gameTemp.reserveCutscene('annie_heart_event_one');
    $gamePlayer.reserveTransfer(mapId, 11, 12, Direction.DOWN, 0, false);
    Switches.hidePlayer = true;
    return true;
  }

  static checkEventPhisShenanigans() {
    if (Switches.playedPhisShenanigans) return;
    if (Switches.canPlayPhisShenanigans) return;

    if (!Managers.Relationship.isCharacterKnown('Phi')) return;
    if (Managers.Relationship.getHeartsNum('Annie') < 1) return;
    if (Managers.Relationship.getHeartsNum('Phi') < 1) return;

    Switches.canPlayPhisShenanigans = true;
  }
}

Managers.Content.registerContentClass(AnnieContent);