const BaseVillager = require('../_system/BaseVillager');

class Annie extends BaseVillager {
  static getVillagerName() {
    return 'Annie';
  }

  static validMaps() {
    return [
      Maps.ORANGE_TOWN,
      Maps.LIBRARY,
      Maps.RESTAURANT
    ];
  }

  static onChangeTime() {
    if (!Managers.Relationship.isCharacterKnown('Annie')) return;

    super.onChangeTime();
  }

  static onUpdateVillagers() {
    if (!Managers.Relationship.isCharacterKnown('Annie')) return;
    super.onUpdateVillagers();
  }

  static onSetupMapEvents() {
    if (!Managers.Relationship.isCharacterKnown('Annie')) return;
    super.onSetupMapEvents();
  }

  static chat(methods) {
    const { play, playOneDayPerWeek, playOneDayPerMonth, playIfRepeatingToday } = methods;
    // #ToDo: Companion


    const checkTaskConversations = () => {
      if (Managers.Time.totalDays < 15) {
        return false;
      }

      if (!Switches.playedPhisShenanigans) {
        return play('annie_phi_shenanigans');
      }
      if (playIfRepeatingToday('annie_phi_shenanigans')) return true;

      if (!Managers.Tasks.isTaskKnown('annies-wand')) {
        return play('annies_wand_introduction');
      }

      if (!Managers.Tasks.isTaskKnown('annies-hobby') && Managers.Tasks.isTaskComplete('annies-wand')) {
        return play('annies_hobby_introduction');
      }
    };

    if (Managers.Time.isBetweenTimes('00:00', '08:51')) {
      return play('annie_default');
    }

    if (Managers.Time.hour >= 21) {
      return play('annie_default');
    }

    if (Managers.Weather.isRaining()) {
      return play('annie_rainy_days');
    }

    // Walking to the library
    if (Managers.Time.isBetweenTimes('08:52', '10:08')) {
      if (playOneDayPerWeek(
        [
          'annie_walking_to_library_morning_1',
          'annie_walking_to_library_morning_2',
          // 'annie_walking_to_library_morning_3',
        ])) {
        return true;
      }
    }

    // Standing in front of the library
    if (Managers.Time.isBetweenTimes('10:09', '12:22')) {
      if (playOneDayPerWeek(
        [
          'annie_in_front_of_library_1',
          // 'annie_in_front_of_library_2',
          // 'annie_in_front_of_library_3',
        ])) {
        return true;
      }

      if (checkTaskConversations()) {
        return true;
      }
    }

    // Going to the restaurant
    if (Managers.Time.isBetweenTimes('12:23', '12:49')) {
      // if (playOneDayPerWeek(
      //   [
      //     'annie_going_to_restaurant_1',
      //     'annie_going_to_restaurant_2',
      //     'annie_going_to_restaurant_3',
      //   ])) {
      //   return true;
      // }
    }

    // In the restaurant
    if (Managers.Time.isBetweenTimes('12:50', '15:18')) {
      if (playOneDayPerWeek(
        [
          'annie_in_restaurant_1',
          // 'annie_in_restaurant_2',
          // 'annie_in_restaurant_3',
        ])) {
        return true;
      }
    }

    // Going to the library
    if (Managers.Time.isBetweenTimes('15:19', '15:50')) {
      // if (playOneDayPerWeek(
      //   [
      //     'annie_going_to_library_1',
      //     'annie_going_to_library_2',
      //     'annie_going_to_library_3',
      //   ])) {
      //   return true;
      // }
    }

    // In the library
    if (Managers.Time.isBetweenTimes('15:51', '18:36')) {
      if (playOneDayPerWeek(
        [
          // 'annie_in_library_1',
          'annie_in_library_2',
          // 'annie_in_library_3',
        ])) {
        return true;
      }
    }

    // Walking around town
    if (Managers.Time.isBetweenTimes('18:37', '20:56')) {
      if (playOneDayPerWeek(
        [
          'annie_walking_around_town_1',
          // 'annie_walking_around_town_2',
          // 'annie_walking_around_town_3',
        ])) {
        return true;
      }
    }

    const monthName = ['spring', 'summer', 'fall', 'winter'][Managers.Time.month - 1];

    if (Managers.Time.day <= 10) {
      if (playOneDayPerMonth(
        [
          `annie_early_${ monthName }_1`,
          `annie_early_${ monthName }_2`,
          `annie_early_${ monthName }_3`,
        ])) {
        return true;
      }
    } else if (Managers.Time.day <= 20) {
      if (playOneDayPerMonth(
        [
          `annie_middle_${ monthName }_1`,
          `annie_middle_${ monthName }_2`,
          `annie_middle_${ monthName }_3`,
        ])) {
        return true;
      }
    } else {
      if (playOneDayPerMonth(
        [
          `annie_late_${ monthName }_1`,
          `annie_late_${ monthName }_2`,
          `annie_late_${ monthName }_3`,
        ])) {
        return true;
      }
    }

    // #ToDo: Add more

    if (checkTaskConversations()) {
      return true;
    }

    return play('annie_default');
  }
}

Annie.register();

module.exports = Annie;