const Amanda = require('./Amanda');

class AmandaContent {
  static contentId() {
    return 'amanda';
  }

  static processNewDay() {
    Switches.amandaGaveFlowerSeedsToday = false;
    Switches.sawAmandaChloeDiscussionToday = false;
  }

  static getCurrentSchedule(villagerName) {
    if (villagerName.toLowerCase() != 'amanda') return;

    if (Managers.Time.month == Seasons.WINTER) {
      return 'winter';
    }

    if (Managers.Weather.isBadWeather()) {
      return 'raining';
    }

    if (Managers.Time.weekDay === Days.MONDAY) {
      if (Managers.Time.isBetweenTimes('10:22', '11:15')) {
        return 'monday';
      }
    }
  }

  static parsePluginCommand(parser, command, args) {
    if (command.toUpperCase() !== 'AMANDA') {
      return;
    }

    switch(parser.name.toUpperCase()) {
      case 'OPENDOOR':
        Amanda.openDoor();
        return true;
      case 'CLOSEDOOR':
        Amanda.closeDoor();
        return true;
      case 'CHAT':
        {
          const methods = Managers.Villagers.buildContextChatMethods('Amanda', parser.interpreter);
          Amanda.chat(methods);
        }
        return true;
    }
  }
}

Managers.Content.registerContentClass(AmandaContent);