const BaseVillager = require('../_system/BaseVillager');

class Amanda extends BaseVillager {
  static getVillagerName() {
    return 'Amanda';
  }

  static validMaps() {
    return [
      Maps.ORANGE_TOWN,
      Maps.FOREST
    ];
  }

  static _chatDefaultSchedule(methods) {
    const { play, playOnePerWeekDay, playBestEvent } = methods;

    if (Managers.Time.hour < 6) {
      return play('amanda_default');
    }

    // Super early, before she even left her house
    if (Managers.Time.isBetweenTimes('06:00', '06:16')) {
      return play('amanda_youre_here_early');
    }

    // Walking to the restaurant area, fixed conversation
    if (Managers.Time.isBetweenTimes('06:17', '06:34')) {
      return play('amanda_going_to_restaurant_area');
    }

    // Waiting for Chloe to arrive, mention her
    if (Managers.Time.isBetweenTimes('06:35', '07:15')) {
      return play('amanda_waiting_for_chloe');
    }

    // While they are both standing there, trigger a different conversation every day of the week.
    if (Managers.Time.isBetweenTimes('06:35', '09:26')) {
      // ToDo: Make sure chloe is there;
      // Check companion and other possible schedules

      if (playOnePerWeekDay(
        [
          'amanda_with_chloe_sunday',
          'amanda_with_chloe_monday',
          false,
          false,
          'amanda_with_chloe_thursday',
          'amanda_with_chloe_friday',
          false
        ])) {
        return true;
      }

      return playBestEvent([
        'amanda_with_chloe_1',
        'amanda_with_chloe_2',
        'amanda_with_chloe_3'
      ]);
    }

    // Going home
    if (Managers.Time.isBetweenTimes('09:27', '09:45')) {
      return playBestEvent([
        'amanda_going_home_morning_1',
        'amanda_going_home_morning_2',
        'amanda_going_home_morning_3',
      ]);
    }

    // At home
    if (Managers.Time.isBetweenTimes('09:46', '10:45')) {
      return playBestEvent([
        'amanda_home_morning_1',
        'amanda_home_morning_2',
        'amanda_home_morning_3',
      ]);
    }

    // Going to the forest
    if (Managers.Time.isBetweenTimes('10:46', '11:34')) {
      return playBestEvent([
        'amanda_going_to_forest_1',
      ]);
    }

    // In the forest, going to the spring
    if (Managers.Time.isBetweenTimes('11:35', '13:35')) {
      return playBestEvent([
        'amanda_going_to_forest_spring_1',
      ]);
    }

    // In the forest spring
    if (Managers.Time.isBetweenTimes('13:36', '16:40')) {
      return playBestEvent([
        'amanda_at_the_spring_1',
      ]);
    }

    // Going back to town
    if (Managers.Time.isBetweenTimes('16:41', '18:50')) {
      return playBestEvent([
        'amanda_coming_back_to_town_1',
      ]);
    }

    // Going Home
    if (Managers.Time.isBetweenTimes('18:51', '19:50')) {
      return playBestEvent([
        'amanda_going_back_home_1',
      ]);
    }

    // In her house
    if (Managers.Time.isBetweenTimes('18:51', '21:59')) {
      return playBestEvent([
        'amanda_night_1',
      ]);
    }

    if (Managers.Time.hour >= 22) {
      return play('amanda_default');
    }
  }

  static _chatMondaySchedule(methods) {
    const { play, playBestEvent } = methods;

    // Going to Ilda's House
    if (Managers.Time.isBetweenTimes('10:22', '10:45')) {
      return play('amanda_going_to_ilda');
    }

    // Talking with Ilda
    if (Managers.Time.isBetweenTimes('10:46', '11:11')) {
      return playBestEvent([
        'amanda_with_ilda_1',
      ]);
    }

    return Amanda._chatDefaultSchedule(methods);
  }

  static _chatRainSchedule(methods) {
    const {playOnePerWeekDay, playBestEvent } = methods;

    if (playOnePerWeekDay(['amanda_rain_sunday', 'amanda_rain_monday'])) {
      return true;
    }

    return playBestEvent(['amanda_rain_week_1', 'amanda_rain_week_2']);
  }

  static _chatWinterSchedule(methods) {
    const { play } = methods;

    return play('amanda_winter');
  }

  static chat(methods) {
    const { play } = methods;
    // #ToDo: Companion

    const schedule = Managers.Villagers.getCurrentSchedule('Amanda');
    const chatFn = {
      monday: Amanda._chatMondaySchedule,
      raining: Amanda._chatRainSchedule,
      winter: Amanda._chatWinterSchedule,
      default: Amanda._chatDefaultSchedule,
    }[schedule] || Amanda._chatDefaultSchedule;

    if (chatFn(methods)) {
      return true;
    }

    return play('amanda_default');
  }
}

Amanda.register();

module.exports = Amanda;