require('game/sprites/crops/Shadow');

class TreeShadow extends Sprites.Shadow {
  updateBitmap() {
    this._tilesetId = $gameMap.tilesetId();
    this._tileId = 0;
    this._iconIndex = 0;
    this._characterName = this._farmObject._characterName;
    this._characterIndex = this._farmObject._characterIndex;

    this.setFarmObjectBitmap();

    this._hasFrame = false;
    if (this._changedBitmap) {
      this.longCache = {};
    }
  }

  setFarmObjectBitmap() {
    if (this._oldCharacterName !== this._characterName) {
      this.bitmap = Managers.Images.loadCharacter(this._characterName);
      this._changedBitmap = true;
    }

    this._isBigCharacter = Managers.Images.isBigCharacter(this._characterName);
    this._isCharacterRow = Managers.Images.isCharacterRow(this._characterName);
    this._oldCharacterName = this._characterName;
    this._isSingleImage = Managers.Images.isSingleImage(this._characterName);
  }

  farmObjectDirection() {
    return 8;
  }

  farmObjectPattern() {
    return 2;
  }
}

module.exports = TreeShadow;
Sprites.TreeShadow = TreeShadow;