require('./TreeShadow');

class FruitTreeShadow extends Sprites.TreeShadow {
  getSmallShadowY() {
    return 5;
  }

  getMediumShadowY() {
    return 9;
  }

  getLargeShadowY() {
    return 18;
  }

  getAdditionalOffsetX() {
    return 0;
  }

  getAdditionalOffsetY() {
    if (!this._farmObject || !this._farmObject._farmObjectData || !this._farmObject._farmObjectData.modelName) return 0;

    // Some special trees have special shadows
    const modelName = this._farmObject._farmObjectData.modelName;

    if (modelName.startsWith('small-tree')) {
      return this.getSmallShadowY();
    }
    if (modelName.startsWith('medium-tree')) {
      return this.getMediumShadowY();
    }

    switch (this._farmObject._farmObjectData.stage) {
      case 1:
        return this.getSmallShadowY();
      case 2:
        return this.getMediumShadowY();
      default:
        return this.getLargeShadowY();
    }
  }
}

module.exports = FruitTreeShadow;
Sprites.FruitTreeShadow = FruitTreeShadow;