require('game/objects/core/AnimatedObject');

Objects.AnimatedTree = class AnimatedTree extends Objects.AnimatedObject {
  initialAnimationTimeout() {
    return 0;
  }

  startEventAnimation() {
    const myPosition = this._farmObjectData.x % 30;
    const windPosition = Managers.Weather.getWindPosition();

    if (windPosition < myPosition || windPosition > (myPosition + 5)) {
      return;
    }

    this._animationTimeout = this.initialAnimationTimeout();
  }

  allAnimationFrames() {
    const frameLength = 6;

    return [
      { direction: 2, pattern: 0, frameLength: frameLength * 5 },
      { direction: 2, pattern: 1, frameLength },
      { direction: 2, pattern: 2, frameLength },
      { direction: 4, pattern: 0, frameLength },
      { direction: 4, pattern: 1, frameLength },
      { direction: 4, pattern: 2, frameLength },
      { direction: 6, pattern: 0, frameLength },
      { direction: 6, pattern: 1, frameLength },
      { direction: 6, pattern: 2, frameLength },
      { direction: 8, pattern: 0, frameLength },
      { direction: 8, pattern: 1, frameLength },
    ];
  }

  getShadowSpriteClass() {
    return Sprites.TreeShadow;
  }

  createShadowSprite() {
    if (this._shadowSprite && !this._shadowSprite._destroyed) {
      return this._shadowSprite;
    }

    const classType = this.getShadowSpriteClass();
    this._shadowSprite = new classType(this);
    return this._shadowSprite;
  }

  createSprites() {
    return [
      this.createSprite(),
      this.createShadowSprite(),
    ];
  }

  shouldStopAnimation() {
    return true;
  }
};

module.exports = Objects.AnimatedTree;