require('game/models/Crop');

Models.TreeCrop = class TreeCrop extends Models.Crop {

  static getHitboxX(gameObject, data) {
    return 0.25;
  }
  static getHitboxY(gameObject, data) {
    return 0.5;
  }
  static getHitboxWidth(gameObject, data) {
    return 0.5;
  }
  static getHitboxHeight(gameObject, data) {
    return 0.25;
  }
  static getOffsetX(gameObject, data) {
    return 0;
  }
  static getOffsetY(gameObject, data) {
    return -8;
  }

  static regrows() {
    return true;
  }

  static getStageCaps() {
    return [5, 30, 60, 70];
  }

  static getWateredDeathChance() {
    return 0;
  }

  static getDryDeathChance() {
    return 0;
  }

  static getMinDeathAge() {
    return 240;
  }

  // return a season here to use the sprite of that season whenever the crop is in its own season
  // example: if the tree gives fruit on spring and this method returns summer, the summer sprite will be displayed on spring too.
  static getFruitSeason() {
    return Seasons.SUMMER;
  }

  static getSpriteIdentification(gameObject) {
    return this.cropName;
  }

  static getWinterLargeSpriteName(gameObject) {
    return 'crops/winter/$large';
  }

  static getWinterMediumSpriteName(gameObject) {
    return 'crops/winter/$medium';
  }

  static getWinterSmallSpriteName(gameObject) {
    return 'crops/winter/$small';
  }

  static getDeadLargeSpriteName(gameObject) {
    return 'crops/dead/$large';
  }

  static getWinterSpriteIndex(gameObject) {
    return 0;
  }

  static getDeadSpriteIndex(gameObject) {
    return 0;
  }

  static getLargeSpriteName(gameObject) {
    let season = Managers.Map.mapMonth(gameObject.mapId);
    if (season === Seasons.WINTER) {
      return this.getWinterLargeSpriteName(gameObject);
    }

    if (gameObject.spoiled) {
      return this.getDeadLargeSpriteName(gameObject);
    }

    return `crops/${ this.getSpriteIdentification(gameObject) }/large`;
  }

  static getMediumSpriteName(gameObject) {
    let season = Managers.Map.mapMonth(gameObject.mapId);
    if (season === Seasons.WINTER) {
      return this.getWinterMediumSpriteName(gameObject);
    }

    return `crops/${ this.getSpriteIdentification(gameObject) }/medium`;
  }

  static getSmallSpriteName(gameObject) {
    let season = Managers.Map.mapMonth(gameObject.mapId);
    if (season === Seasons.WINTER) {
      return this.getWinterSmallSpriteName(gameObject);
    }

    return `crops/${ this.getSpriteIdentification(gameObject) }/small`;
  }

  static getFruitSpriteName(gameObject) {
    return this.getLargeSpriteName(gameObject);
  }

  static getStageSpriteName(stage, gameObject) {
    switch(stage) {
      case 1:
        return this.getSmallSpriteName(gameObject);
      case 2:
        return this.getMediumSpriteName(gameObject);
      case 3:
        return this.getLargeSpriteName(gameObject);
      case 4:
        return this.getFruitSpriteName(gameObject);
      default:
        return this.getLargeSpriteName(gameObject);
    }
  }

  static getCurrentSpriteIndex(gameObject, season, stage) {
    if (season === Seasons.WINTER) {
      return this.getWinterSpriteIndex(gameObject);
    }
    if (stage >= 3 && gameObject.spoiled) {
      return this.getDeadSpriteIndex(gameObject);
    }

    let seasonIndex = 0;

    switch(season) {
      case 3:
        seasonIndex = 2;
        break;
    }

    if (stage === 4 && this.cropGrownsOnSeason(season)) {
      return seasonIndex + 4;
    }

    return seasonIndex;
  }

  static getData(gameObject) {
    return this.normalizeData(this.getCropData(gameObject));
  }

  static getCropData(gameObject) {
    const stage = this.stage(gameObject);
    let season = Managers.Map.mapMonth(gameObject.mapId);
    
    // If the fruit can grow on the current season, then use the sprite of fruitSeason instead of the current one
    const fruitSeason = this.getFruitSeason();
    if (fruitSeason && this.cropGrownsOnSeason(season)) {
      season = fruitSeason;
    }

    const data = this.getTreeStageData(gameObject, season, stage);
    return this.normalizeData(data);
    // return {
    //   spriteName: gameObject.spoiled ? this.getDeadSpriteName() : this.getRegularSpriteName(),
    //   spriteIndex: this.getCropSpriteIndex(),
    //   direction: this.getCropDirection(),
    //   pattern: stage -1,
    //   priority: this.getCropPriority(),
    // };
  }

  static getTreeStageData(gameObject, season, stage) {
    let validStage = stage;
    const mapSeason = Managers.Map.mapMonth(gameObject.mapId);

    if (validStage >= 4 && !this.cropGrownsOnSeason(mapSeason)) {
      validStage = 3;
    }

    const spriteName = this.getStageSpriteName(validStage, gameObject);
    const spriteIndex = this.getCurrentSpriteIndex(gameObject, season, stage);

    return {
      spriteName,
      spriteIndex,
      priority: 1,
      direction: Direction.DOWN,
      pattern: 0
    };
  }

  static processGameObjectNewDay(gameObject) {
    const season = Managers.Map.mapMonth(gameObject.mapId);
    const stage = this.stage(gameObject);
    const stageCaps = this.getStageCaps();

    if (stage == stageCaps.length - 1 && this.cropGrownsOnSeason(season)) {
      const points = this.pointsToGrowByDay;
      gameObject.increasePoints(stageCaps, points);
    } else if (stage < stageCaps.length - 1) {
      gameObject.increasePoints(stageCaps);
    }
  }

  static get pointsToGrowByDay() {
    return Math.randomInt(4) + 1;
  }

  static isTree() {
    return true;
  }

  static isFlower() {
    return false;
  }

  static hasCollision() {
    return true;
  }
};
