require('./TreeCrop');

Models.PurpleTree = class PurpleTree extends Models.TreeCrop {
  static get modelName() {
    return 'regular-tree-2';
  }

  static get cropName() {
    return 'purple-tree';
  }

  static getObjectClassType() {
    return Objects.FruitTree;
  }

  static get pointsToGrowByDay() {
    return 1;
  }

  static getStageCaps() {
    return [5, 10, 15];
  }

  static cropGrownsOnSeason(/*season*/) {
    return false;
  }
};

Managers.FarmObjects.registerTallModel(Models.PurpleTree.modelName);