require('./TreeCrop');

Models.PinkTree = class PinkTree extends Models.TreeCrop {
  static get modelName() {
    return 'regular-tree';
  }

  static get cropName() {
    return 'pink-tree';
  }

  static getObjectClassType() {
    return Objects.FruitTree;
  }

  static get pointsToGrowByDay() {
    return 1;
  }

  static getStageCaps() {
    return [5, 10, 15];
  }

  static cropGrownsOnSeason(/*season*/) {
    return false;
  }
};

// different pink tree, if I choose to add a new variety later I can use this
Models.PinkTree2 = class PinkTree2 extends Models.PinkTree {
  static get modelName() {
    return 'regular-tree-5';
  }
};

Managers.FarmObjects.registerTallModel(Models.PinkTree.modelName);
Managers.FarmObjects.registerTallModel(Models.PinkTree2.modelName);