require('./TreeCrop');

Models.IpeTree = class IpeTree extends Models.TreeCrop {
  static get modelName() {
    return 'ipe';
  }

  static get pointsToGrowByDay() {
    return 1;
  }

  static getStageCaps() {
    return [0, 0, 0];
  }

  static cropGrownsOnSeason(/*season*/) {
    return false;
  }

  static getObjectClassType() {
    return Objects.IpeTree;
  }

  static getLargeSpriteName(gameObject) {
    let season = Managers.Map.mapMonth(gameObject.mapId);
    if (season !== Seasons.WINTER) {
      return `crops/ipe/large`;
    }

    if (gameObject.spoiled) {
      return this.getDeadLargeSpriteName(gameObject);
    }

    return `crops/ipe/winter`;
  }

  static getMediumSpriteName(gameObject) {
    return this.getLargeSpriteName(gameObject);
  }

  static getSmallSpriteName(gameObject) {
    return this.getLargeSpriteName(gameObject);
  }

  static getCurrentSpriteIndex(gameObject, season, stage) {
    if (season !== Seasons.WINTER) {
      return this.getDeadSpriteIndex(gameObject);
    }
    if (gameObject.spoiled) {
      return this.getDeadSpriteIndex(gameObject);
    }

    if (gameObject.ipeIndex && gameObject.ipeIndex < 8) {
      return gameObject.ipeIndex;
    }

    return 0;
  }
};

Managers.FarmObjects.registerTallModel(Models.IpeTree.modelName);
