require('./TreeCrop');

Models.GreenTree = class GreenTree extends Models.TreeCrop {
  static get modelName() {
    return 'regular-tree-3';
  }

  static get cropName() {
    return 'green-tree';
  }

  static getObjectClassType() {
    return Objects.FruitTree;
  }

  static get pointsToGrowByDay() {
    return 1;
  }

  static getStageCaps() {
    return [5, 10, 15];
  }

  static cropGrownsOnSeason(/*season*/) {
    return false;
  }

  static getSpriteIdentification() {
    return 'pink-tree';
  }

  static getCurrentSpriteIndex(gameObject, season, stage) {
    if (season === Seasons.WINTER) {
      return 0;
    }
    if (stage >= 3 && gameObject.spoiled) {
      return 0;
    }

    switch(season) {
      case 3:
        return 2;
      default:
        return 0;
    }
  }
};


// Green, using different Y position
Models.GreenTree2 = class GreenTree4 extends Models.GreenTree {
  static get modelName() {
    return 'regular-tree-4';
  }

  static getHitboxY() {
    return 0;
  }

  static getHitboxX() {
    return 0.25;
  }

  static getHitboxWidth() {
    return 0.5;
  }

  static getHitboxHeight() {
    return 0.25;
  }

  static getOffsetX() {
    return -8;
  }

  static getOffsetY() {
    return -24;
  }
};

// different green tree, if I choose to add a new variety later I can use this
Models.GreenTree3 = class GreenTree3 extends Models.GreenTree {
  static get modelName() {
    return 'regular-tree-6';
  }
};

Managers.FarmObjects.registerTallModel(Models.GreenTree.modelName);
Managers.FarmObjects.registerTallModel(Models.GreenTree2.modelName);
Managers.FarmObjects.registerTallModel(Models.GreenTree3.modelName);