require('./TreeCrop');

Models.GiantTree = class GiantTree extends Models.TreeCrop {
  static get modelName() {
    return 'giant-tree';
  }

  static get cropName() {
    return 'giant';
  }

  static getStageCaps() {
    return [0, 0, 0];
  }

  static getHitboxX() {
    return 0;
  }

  static getHitboxY() {
    return 0.5;
  }

  static getHitboxWidth() {
    return 1;
  }

  static getHitboxHeight() {
    return 0.5;
  }

  static getOffsetY() {
    return 8;
  }

  static cropGrownsOnSeason(/*season*/) {
    return false;
  }

  static stage(gameObject) {
    return 3;
  }

  static getCurrentSpriteIndex(gameObject, season, stage) {
    switch(season) {
      case 1:
        return 0;
      case 2:
        return 1;
      case 3:
        return 2;
      case 4:
        return 3;
    }
  }

  static getObjectClassType() {
    return Objects.GiantTree;
  }
};

Managers.FarmObjects.registerLargeModel(Models.GiantTree.modelName);
Managers.FarmObjects.registerTallModel(Models.GiantTree.modelName);