require('./TreeCrop');

Models.DesertTree = class DesertTree extends Models.TreeCrop {
  static get modelName() {
    return 'desert-tree';
  }

  static getStageCaps() {
    return [5, 30, 60];
  }

  static getLargeSpriteName() {
    return `crops/palm/large`;
  }

  static getCurrentSpriteIndex(gameObject, season, stage) {
    return 0;
  }

  static getHitboxX() {
    return 0.25;
  }

  static getHitboxY() {
    return 0;
  }

  static getHitboxWidth() {
    return 0.5;
  }

  static getHitboxHeight() {
    return 0.5;
  }

  static stage(gameObject) {
    return 3;
  }

  static getObjectClassType() {
    return Objects.PalmTree;
  }
};

Managers.FarmObjects.registerTallModel(Models.DesertTree.modelName);