require('./TreeCrop');

Models.CoconutTree = class CoconutTree extends Models.TreeCrop {
  static get cropName() {
    return 'coconut';
  }

  static getHitboxX() {
    return 0.25;
  }

  static getHitboxY() {
    return 0;
  }

  static getHitboxWidth() {
    return 0.5;
  }

  static getHitboxHeight() {
    return 0.5;
  }

  static stage(gameObject) {
    const stage = super.stage(gameObject);
    if (stage < 3) {
      return 3;
    }

    return stage;
  }

  static getWinterLargeSpriteName(gameObject) {
    return 'crops/coconut/large';
  }

  static getDeadLargeSpriteName(gameObject) {
    return 'crops/coconut/large';
  }

  static getCurrentSpriteIndex(gameObject, season, stage) {
    if (stage === 4 && this.cropGrownsOnSeason(season)) {
      return 4;
    }

    return 0;
  }

  static getObjectClassType() {
    return Objects.CoconutTree;
  }
};

Managers.FarmObjects.registerTallModel(Models.CoconutTree.modelName);