require('game/managers/Content');

class TrashCanContent {
  static contentId() {
    return 'trash-can';
  }

  static processNewDay() {
    this.clearTrashCanContent();

    this.generateRandomItem();
  }

  static onChangeMinute() {
    if (Utils.chance(15)) {
      this.generateRandomItem();
    }
  }

  static clearTrashCanContainerContent(container) {
    const items = container._items;
    const len = items.length;

    for (let i = 0; i < len; i++) {
      const item = items[i];
      if (!item) continue;

      if (Managers.Items.canItemBeTrashed(item)) {
        Managers.History.registerItemTrashed(item.id, item.amount);

        container.loseItem(item, item.amount);
      }
    }
  }

  static clearTrashCanContent() {
    const containers = Managers.Items.getAllTrashContainers();

    for (const container of containers) {
      this.clearTrashCanContainerContent(container);
    }
  }

  static generateRandomItem() {
    const luck = Math.randomInt(130);
    
    const containers = Managers.Items.getAllTrashContainers();
    const idx = Math.randomInt(containers.length);

    let container = Managers.Items.trashContainer;

    if (containers[idx]) {
      container = containers[idx];
    }

    if (luck < 10) {
      container.gainItemId('red-can');
    } else if (luck < 20) {
      container.gainItemId('green-can');
    } else if (luck < 40) {
      container.gainItemId('old-boot');
    } else if (luck < 50) {
      container.gainItemId('old-tire');
    } else if (luck < 60) {
      container.gainItemId('weeds');
    } else if (luck < 70) {
      container.gainItemId('spoiled-apple');
    } else if (luck < 80) {
      container.gainItemId('spoiled-orange');
    } else if (luck < 90) {
      container.gainItemId('rock');
    } else if (luck < 100) {
      container.gainItemId('clay');
    } else if (luck < 110) {
      container.gainItemId('branch');
    } else if (luck < 120) {
      container.gainItemId('wooden-stick');
    } else if (luck < 130) {
      container.gainItemId('bad-perfume');
    }
  }
}

Managers.Content.registerContentClass(TrashCanContent);