require('game/managers/Content');

class ToolUpgradesContent {
  static contentId() {
    return 'tool-upgrades';
  }

  static parsePluginCommand(parser, command, args) {
    // setUpgradedToolEvent
    if (command.toUpperCase() === 'SETUPGRADEDTOOLEVENT') {
      const upgradeType = parser.name;
      Variables.viktorToolUpgradeEvent = Variables.viktorToolBeingUpgraded + `_${ upgradeType }_upgrade_complete`;
      return true;
    }

    if (command.toUpperCase() === 'ADDTOOL') {
      const toolName = parser.nameMaybeVariable(true);
      this.addTool(toolName);
      return true;
    }

    if (command.toUpperCase() === 'OPENBLACKSMITH') {
      Managers.Scenes.push(GameScenes.OrangeTownBlacksmith);
      return true;
    }

    if (command.toUpperCase() === 'OPENORESHOP') {
      Managers.Scenes.push(GameScenes.OreShop);
      return true;
    }
  }


  static numItems(item) {
    if (item.type !== 'tool') return;

    switch (item.id) {
      case 'fishing-rod':
        return Switches.hasFishingRod ? 1 : 0;
      case 'green-fishing-rod':
        return Switches.hasGreenFishingRod ? 1 : 0;
      case 'blue-fishing-rod':
        return Switches.hasBlueFishingRod ? 1 : 0;

      case 'iron-hoe':
        return Switches.hasIronHoe ? 1 : 0;
      case 'copper-hoe':
        return Switches.hasCopperHoe ? 1 : 0;
      case 'silver-hoe':
        return Switches.hasIronHoe ? 1 : 0;
      case 'golden-hoe':
        return Switches.hasGoldenHoe ? 1 : 0;
      case 'diamond-hoe':
        return Switches.hasDiamondHoe ? 1 : 0;

      case 'iron-sickle':
        return Switches.hasIronSickle ? 1 : 0;
      case 'copper-sickle':
        return Switches.hasCopperSickle ? 1 : 0;
      case 'silver-sickle':
        return Switches.hasIronSickle ? 1 : 0;
      case 'golden-sickle':
        return Switches.hasGoldenSickle ? 1 : 0;
      case 'diamond-sickle':
        return Switches.hasDiamondSickle ? 1 : 0;

      case 'iron-axe':
        return Switches.hasIronAxe ? 1 : 0;
      case 'copper-axe':
        return Switches.hasCopperAxe ? 1 : 0;
      case 'silver-axe':
        return Switches.hasIronAxe ? 1 : 0;
      case 'golden-axe':
        return Switches.hasGoldenAxe ? 1 : 0;
      case 'diamond-axe':
        return Switches.hasDiamondAxe ? 1 : 0;

      case 'iron-hammer':
        return Switches.hasIronHammer ? 1 : 0;
      case 'copper-hammer':
        return Switches.hasCopperHammer ? 1 : 0;
      case 'silver-hammer':
        return Switches.hasIronHammer ? 1 : 0;
      case 'golden-hammer':
        return Switches.hasGoldenHammer ? 1 : 0;
      case 'diamond-hammer':
        return Switches.hasDiamondHammer ? 1 : 0;

      case 'watering-can':
        return Switches.hasRegularWateringCan ? 1 : 0;
      case 'silver-watering-can':
        return Switches.hasSilverWateringCan ? 1 : 0;
      case 'red-watering-can':
        return Switches.hasRedWateringCan ? 1 : 0;
      case 'green-watering-can':
        return Switches.hasGreenWateringCan ? 1 : 0;
    }
  }

  static pickItemId(itemId, amount, mailboxIfFull) {
    switch (itemId) {
      case 'iron-hoe':
        return false;
      case 'copper-hoe':
        Managers.Villagers.playDialogue('Viktor', 'trigger_hoe_copper_upgrade');
        return true;
      case 'silver-hoe':
        Managers.Villagers.playDialogue('Viktor', 'trigger_hoe_silver_upgrade');
        return true;
      case 'golden-hoe':
        Managers.Villagers.playDialogue('Viktor', 'trigger_hoe_gold_upgrade');
        return true;
      case 'diamond-hoe':
        return false;

      case 'iron-sickle':
        return false;
      case 'copper-sickle':
        Managers.Villagers.playDialogue('Viktor', 'trigger_sickle_copper_upgrade');
        return true;
      case 'silver-sickle':
        Managers.Villagers.playDialogue('Viktor', 'trigger_sickle_silver_upgrade');
        return true;
      case 'golden-sickle':
        Managers.Villagers.playDialogue('Viktor', 'trigger_sickle_gold_upgrade');
        return true;
      case 'diamond-sickle':
        // Managers.Villagers.playDialogue('Viktor', 'trigger_sickle_diamond_upgrade');
        return false;

      case 'iron-axe':
        return false;
      case 'copper-axe':
        Managers.Villagers.playDialogue('Viktor', 'trigger_axe_copper_upgrade');
        return true;
      case 'silver-axe':
        Managers.Villagers.playDialogue('Viktor', 'trigger_axe_silver_upgrade');
        return true;
      case 'golden-axe':
        Managers.Villagers.playDialogue('Viktor', 'trigger_axe_gold_upgrade');
        return true;
      case 'diamond-axe':
        // Managers.Villagers.playDialogue('Viktor', 'trigger_axe_diamond_upgrade');
        return false;

      case 'iron-hammer':
        return false;
      case 'copper-hammer':
        Managers.Villagers.playDialogue('Viktor', 'trigger_hammer_copper_upgrade');
        return true;
      case 'silver-hammer':
        Managers.Villagers.playDialogue('Viktor', 'trigger_hammer_silver_upgrade');
        return true;
      case 'golden-hammer':
        Managers.Villagers.playDialogue('Viktor', 'trigger_hammer_gold_upgrade');
        return true;
      case 'diamond-hammer':
        // Managers.Villagers.playDialogue('Viktor', 'trigger_hammer_diamond_upgrade');
        return false;

      case 'watering-can':
        return false;
      case 'silver-watering-can':
        Managers.Villagers.playDialogue('Viktor', 'trigger_wateringcan_silver_upgrade');
        return true;
      case 'red-watering-can':
        Managers.Villagers.playDialogue('Viktor', 'trigger_wateringcan_red_upgrade');
        return true;
      case 'green-watering-can':
        Managers.Villagers.playDialogue('Viktor', 'trigger_wateringcan_green_upgrade');
        return true;

      case 'green-fishing-rod':
        Managers.Villagers.playDialogue('Viktor', 'trigger_fishingrod_green_upgrade');
        return true;
      case 'blue-fishing-rod':
        Managers.Villagers.playDialogue('Viktor', 'trigger_fishingrod_blue_upgrade');
        return true;
    }
  }

  static pickItem(item, amount) {
    return this.pickItemId(item.id, amount);
  }

  static canGainItem(item) {
    if (item.type !== 'tool') return;

    switch (item.id) {
      case 'iron-hoe':
        return true;
      case 'copper-hoe':
        return true;
      case 'silver-hoe':
        return true;
      case 'golden-hoe':
        return true;
      case 'diamond-hoe':
        return true;

      case 'iron-sickle':
        return true;
      case 'copper-sickle':
        return true;
      case 'silver-sickle':
        return true;
      case 'golden-sickle':
        return true;
      case 'diamond-sickle':
        return true;

      case 'iron-axe':
        return true;
      case 'copper-axe':
        return true;
      case 'silver-axe':
        return true;
      case 'golden-axe':
        return true;
      case 'diamond-axe':
        return true;

      case 'iron-hammer':
        return true;
      case 'copper-hammer':
        return true;
      case 'silver-hammer':
        return true;
      case 'golden-hammer':
        return true;
      case 'diamond-hammer':
        return true;

      case 'watering-can':
        return true;
      case 'silver-watering-can':
        return true;
      case 'red-watering-can':
        return true;
      case 'green-watering-can':
        return true;
    }
  }

  static addTool(toolId) {
    switch (toolId) {
      case 'iron-hoe':
        Switches.hasIronHoe = true;
        break;
      case 'copper-hoe':
        Switches.hasCopperHoe = true;
        break;
      case 'silver-hoe':
        Switches.hasSilverHoe = true;
        break;
      case 'golden-hoe':
        Switches.hasGoldenHoe = true;
        break;
      case 'diamond-hoe':
        Switches.hasDiamondHoe = true;
        break;

      case 'iron-sickle':
        Switches.hasIronSickle = true;
        break;
      case 'copper-sickle':
        Switches.hasCopperSickle = true;
        break;
      case 'silver-sickle':
        Switches.hasSilverSickle = true;
        break;
      case 'golden-sickle':
        Switches.hasGoldenSickle = true;
        break;
      case 'diamond-sickle':
        Switches.hasDiamondSickle = true;
        break;

      case 'iron-axe':
        Switches.hasIronAxe = true;
        break;
      case 'copper-axe':
        Switches.hasCopperAxe = true;
        break;
      case 'silver-axe':
        Switches.hasSilverAxe = true;
        break;
      case 'golden-axe':
        Switches.hasGoldenAxe = true;
        break;
      case 'diamond-axe':
        Switches.hasDiamondAxe = true;
        break;

      case 'iron-hammer':
        Switches.hasIronHammer = true;
        break;
      case 'copper-hammer':
        Switches.hasCopperHammer = true;
        break;
      case 'silver-hammer':
        Switches.hasSilverHammer = true;
        break;
      case 'golden-hammer':
        Switches.hasGoldenHammer = true;
        break;
      case 'diamond-hammer':
        Switches.hasDiamondHammer = true;
        break;

      case 'watering-can':
        Switches.hasRegularWateringCan = true;
        break;
      case 'silver-watering-can':
        Switches.hasSilverWateringCan = true;
        break;
      case 'red-watering-can':
        Switches.hasRedWateringCan = true;
        break;
      case 'green-watering-can':
        Switches.hasGreenWateringCan = true;
        break;

      case 'green-fishing-rod':
        Switches.hasGreenFishingRod = true;
        break;
      case 'blue-fishing-rod':
        Switches.hasBlueFishingRod = true;
        break;
    }

    Managers.Items.requestHudRefresh();
  }

  static processNewDay() {
    if (Switches.viktorIsUpgradingTool) {
      if (Variables.viktorDaysToComplete > 0) {
        Variables.viktorDaysToComplete--;
      }
    }
  }
}

Managers.Content.registerContentClass(ToolUpgradesContent);
module.exports = ToolUpgradesContent;