require('game/managers/Content');

(function(){

  const countFishTypes = () => {
    let count = 0;
    for (const item of $dataItems) {
      if (!item) continue;
      if (!item.fish) continue;

      count++;
    }

    return count;
  };

  const countFishCaught = () => {
    let count = 0;
    for (const item of $dataItems) {
      if (!item) continue;
      if (!item.fish) continue;

      if (Managers.History.readFishCaught(item.id) > 0) {
        count++;
      }
    }

    return count;
  };


  //////////////////////////////
  // Content Class
  //////////////////////////////
  function SystemDataContent() {
  }

  SystemDataContent.contentId = function() {
    return 'system#SystemData';
  };

  function getTaskStats() {
    let completedTasks = 0;
    let totalTasks = 0;

    const taskGroups = {};

    for (let key in $dataTasks) {
      const taskData = $dataTasks[key];
      if (!taskData) continue;
      if (taskData.hidden) continue;

      const id = taskData.id || key;
      if (!taskGroups[id]) {
        taskGroups[id] = {
          id,
          list: {},
          completed: true
        };
      }

      const status = Managers.Tasks.getTaskStatus(key);
      if (status !== TaskStatus.COMPLETED) {
        taskGroups[id].completed = false;
      }
    }

    for (let id in taskGroups) {
      if (taskGroups[id].completed) {
        completedTasks++;
      }

      totalTasks++;
    }

    return [completedTasks, totalTasks];
  }

  function getAreaStats() {
    let knownAreas = Managers.Map.getDiscoveredAreaList().length;
    let totalAreas = Managers.Map.getActiveMapIds().length;

    return [knownAreas, totalAreas];
  }

  SystemDataContent.getStampValue = function(stampId) {
    switch(stampId) {
      case 'areasFound':
        return getAreaStats(false)[0];
      case 'moneyEarned':
        return Managers.Text.formatMoney(Variables.moneyEarned);
      case 'moneySpent':
        return Managers.Text.formatMoney(Variables.moneySpent);
      case 'tasksCompleted':
        return getTaskStats()[0];
      case 'fishCaught':
        return countFishCaught();
        // return Managers.History.readTotal('fish-caught');
    }
  };

  SystemDataContent.getMaxStampValue = function(stampId) {
    switch(stampId) {
      case 'areasFound':
        return getAreaStats(false)[1];
      case 'moneyEarned':
        return false;
      case 'moneySpent':
        return false;
      case 'tasksCompleted':
        return getTaskStats()[1];
      case 'fishCaught':
        return countFishTypes();
    }
  };

  SystemDataContent.isStampEnabled = function(stampId) {
    switch(stampId) {
      case 'areasFound':
      {
        const areaData = getAreaStats(false);
        return areaData[0] == areaData[1];
      }

      case 'moneyEarned':
        return true;
      case 'moneySpent':
        return true;
      case 'fishCaught':
        return Switches.hasFishingRod;
      case 'tasksCompleted':
      {
        const tasksData = getTaskStats();
        return tasksData[0] == tasksData[1];
      }
    }
  };

  SystemDataContent.getCustomDatabaseSummaryLines = function() {
    return [{
      weight: 1,
      title: t("Areas Found"),
      dataFn: function() {
        const data = getAreaStats();
        return [data[0], data[1]];
      }
    }, {
      weight: 20,
      title: t("Completed Tasks"),
      dataFn: function() {
        // return getTaskStats();

        const completedTasks = getTaskStats()[0];
        // We don't yet have all the tasks, so let's shoot the number up around how many we want there to be by the end of the game.
        const totalTasks = 120;

        return [completedTasks, totalTasks];
      }
    },{
      weight: 20,
      title: t("House Upgrades"),
      dataFn: function() {
        let totalExpansions = 0;
        let completedExpansions = 0;

        totalExpansions++;
        if (Switches.expandedHouse) {
          completedExpansions++;
        }
        if (Switches.builtSecondFloor) {
          completedExpansions++;
        }

        // 2 expansions are not yet implemented
        totalExpansions += 2;

        return [completedExpansions,totalExpansions];
      }
    }];
  };

  Managers.Content.registerContentClass(SystemDataContent);
})();