require('game/managers/Content');

(function(){

  //////////////////////////////
  // Content Class
  //////////////////////////////
  function ItemCounterContent() {
  }

  ItemCounterContent.contentId = function() {
    return 'system#ItemsSummary';
  };

  function getItemsStats() {
    let totalItems = 0;
    let shippedItems = 0;
    let shippableItems = 0;

    for (let i = 0; i < $dataItems.length; i++) {
      const itemData = $dataItems[i];
      if (!itemData) continue;
      if (itemData.disabled) continue;

      totalItems++;

      if (itemData.sellPrice) {
        shippableItems++;

        if (Managers.History.getShippedItems(itemData.id) > 0) {
          shippedItems++;
        }
      }
    }

    return [shippedItems, shippableItems, totalItems];
  }

  ItemCounterContent.getStampValue = function(stampId) {
    if (stampId == 'shippedItems') {
      return getItemsStats()[0];
    }
  };
  ItemCounterContent.getMaxStampValue = function(stampId) {
    if (stampId == 'shippedItems') {
      return getItemsStats()[1];
    }
  };

  ItemCounterContent.isStampEnabled = function(stampId) {
    if (stampId == 'shippedItems') {
      const data = getItemsStats();
      return data[0] == data[1];
    }
  };

  ItemCounterContent.getCustomDatabaseSummaryLines = function() {
    return [{
      weight: 5,
      title: t("Shipped Items"),
      dataFn: function() {
        return getItemsStats();
      }
    }];
  };

  Managers.Content.registerContentClass(ItemCounterContent);
})();