require('game/managers/Content');

(function(){

  //////////////////////////////
  // Content Class
  //////////////////////////////
  function FriendCounterContent() {
  }

  FriendCounterContent.contentId = function() {
    return 'system#FriendsSummary';
  };

  function getFriendsStats(applyRateManipulations) {
    let totalVillagers = 0;
    let knownVillagers = 0;

    for (let i = 0; i < $dataActors.length; i++) {
      const actorData = $dataActors[i];
      if (!actorData) continue;
      if (!actorData.enabled) continue;
      if (!actorData.showOnFriendList) continue;

      const known = Managers.Relationship.isCharacterKnown(actorData.name);

      if (actorData.showOnFriendList === true || known) {
        totalVillagers++;
      }

      if (known) {
        // When calculating the game progress, use the relationship value instead
        if (applyRateManipulations) {
          knownVillagers += Managers.Relationship.getHeartsNum(actorData.name) + 0.2;
        } else {
          knownVillagers++;
        }
      }
    }

    // When calculating the game progress, use the relationship value instead
    if (applyRateManipulations) {
      totalVillagers *= 5.2;
    }

    return [knownVillagers, totalVillagers];
  }

  FriendCounterContent.getStampValue = function(stampId) {
    if (stampId == 'peopleMet') {
      return getFriendsStats(false)[0];
    }
  };
  FriendCounterContent.getMaxStampValue = function(stampId) {
    if (stampId == 'peopleMet') {
      return getFriendsStats(false)[1];
    }
  };

  FriendCounterContent.isStampEnabled = function(stampId) {
    if (stampId == 'peopleMet') {
      const data = getFriendsStats(true);
      return data[0] == data[1];
    }
  };

  FriendCounterContent.getCustomDatabaseSummaryLines = function() {
    return [{
      weight: 10,
      title: t("Friends"),
      dataFn: function() {
        return getFriendsStats(true);
      }
    }, {
      weight: 10,
      title: '???', // t("Marriage"),
      dataFn: function() {
        // Marriage not yet implemented
        return [0, 1];
      }
    }, {
      weight: 5,
      title: '???', // t("Child"),
      dataFn: function() {
        // Children not yet implemented
        return [0, 1];
      }
    }];
  };

  Managers.Content.registerContentClass(FriendCounterContent);
})();