class ConditionParserContent {
  static contentId() {
    return 'condition-parser';
  }

  static parseConditionCommand(parser, command, args) {
    let methodName = 'parse_' + command.toLowerCase();
    while (methodName.indexOf('-') >= 0) {
      methodName = methodName.replace('-', '_');
    }  

    if (this[methodName] !== undefined) {
      try {
        const result = this[methodName](parser);
        if (result !== undefined) {
          return result;
        }
      }
      catch(exception) {
        console.log(exception);
      }
    }
  }

  static parse_morning(parser) {
    return Managers.Time.isBetweenTimes('05:00', '11:59');
  }

  static parse_noon(parser) {
    return Managers.Time.isBetweenTimes('12:00', '12:59');
  }

  static parse_afternoon(parser) {
    return Managers.Time.isBetweenTimes('13:00', '17:59');
  }

  static parse_evening(parser) {
    return Managers.Time.isBetweenTimes('18:00', '19:59');
  }

  static parse_night(parser) {
    return Managers.Time.hour >= 20 || Managers.Time.hour < 5;
  }

  static parse_male(parser) {
    return Managers.Player.getGender() == 'male';
  }

  static parse_time(parser) {
    if (parser.upperName == 'BETWEEN') {
      const firstTime = parser.nextArg(true);

      if (parser.nextUpperArg(false) === 'AND') {
        parser.skipArg(1);
      }

      const secondTime = parser.nextArg(true);

      if (firstTime && secondTime) {
        return Managers.Time.isBetweenTimes(firstTime, secondTime);
      }
    }
  }

  static parse_raining(parser) {
    if (parser.upperName == 'TOMORROW') {
      return Managers.Weather.isRainingTomorrowg();
    }

    return Managers.Weather.isRaining();
  }

  static parse_storm(parser) {
    return Managers.Weather.currentWeather == WeatherType.STORM;
  }

  static parse_bad(parser) {
    if (parser.upperName == 'WEATHER') {
      if (parser.nextUpperArg() === 'TOMORROW')  {
        return Managers.Weather.isBadWeatherTomorrow();
      }

      return Managers.Weather.isBadWeather();
    }
  }

  static parse_first(parser) {
    if (parser.upperName == 'YEAR') {
      return Managers.Time.year === 1;
    }

    if (parser.upperName == 'MONTH') {
      return Managers.Time.year === 1 && Managers.Time.month === 1;
    }
  }

  static parse_sunny(parser) {
    return !Managers.Weather.isBadWeather();
  }

  static parse_spring(parser) {
    return Managers.Time.month === Seasons.SPRING;
  }

  static parse_summer(parser) {
    return Managers.Time.month === Seasons.SUMMER;
  }

  static parse_fall(parser) {
    return Managers.Time.month === Seasons.FALL;
  }

  static parse_winter(parser) {
    return Managers.Time.month === Seasons.WINTER;
  }

  static parse_sunday(parser) {
    return Managers.Time.weekDay === Days.SUNDAY;
  }

  static parse_monday(parser) {
    return Managers.Time.weekDay === Days.MONDAY;
  }

  static parse_tuesday(parser) {
    return Managers.Time.weekDay === Days.TUESDAY;
  }

  static parse_wednesday(parser) {
    return Managers.Time.weekDay === Days.WEDNESDAY;
  }

  static parse_thursday(parser) {
    return Managers.Time.weekDay === Days.THURSDAY;
  }

  static parse_friday(parser) {
    return Managers.Time.weekDay === Days.FRIDAY;
  }

  static parse_saturday(parser) {
    return Managers.Time.weekDay === Days.SATURDAY;
  }

  static parse_has(parser) {
    if (parser.upperName == 'GOLD') {
      const value = parser.nextArgAsFloat();

      if (value || value === 0) {
        return Managers.Items.gold >= value;
      }
    }

    if (parser.upperName == 'FISH') {
      return Managers.Items.hasAnyFish();
    }
  }

  static parse_knows(parser) {
    return Managers.Relationship.isCharacterKnown(parser.name);
  }

  static parse_switch(parser) {
    const switchName = parser.nameMaybeVariable();
    let value = parser.hasMoreArgs() ? parser.nextArgAsBoolean(true) : true;

    return Switches[switchName] === value;
  }

  static parse_variable(parser) {
    const variableName = parser.nameMaybeVariable();
    const operation = parser.nextArgMaybeVariable(true);
    const value = parser.remainingLineMaybeVariable(true);

    const variableValue = Variables[variableName];
    return Utils.compareValues(variableValue, value, operation);
  }

  static parse_response(parser) {
    const responseValue = $gameTemp.getLastResponse();
    const operation = parser.nameMaybeVariable();
    const value = parser.remainingLineMaybeVariable(true);

    return Utils.compareValues(responseValue, value, operation);
  }

  static parse_exp(parser) {
    const expName = parser.nameMaybeVariable();
    const operation = parser.nextArgMaybeVariable(true);
    const value = parser.remainingLineMaybeVariable(true);

    const expValue = Managers.Player[`${ expName }Exp`];
    return Utils.compareValues(expValue, value, operation);
  }

  static parse_tool(parser) {
    if (parser.upperName === 'EQUIPPED') {
      const toolName = parser.nextArgMaybeVariable(true);

      if (toolName) {
        return Managers.Tools.isToolTypeEquipped(toolName);
      }
    }
  }

  static parse_map(parser) {
    let reverse = false;
    let upperName = parser.upperName;

    if (upperName === 'NOT') {
      reverse = true;
      upperName = parser.nextUpperArg(true);
    }

    const realMapId = Managers.Map.getRealMapId($gameMap._mapId);

    if (upperName === 'IN') {
      const mapList = parser.remainingLineMaybeVariable();
      const list = mapList.split(',');
      for (const item of list) {
        const key = item.trim();
        const mapId = Managers.Map.getMapIdByLabel(key);

        if (realMapId === mapId) {
          return !reverse;
        }
      }

      return reverse;
    }

    if (upperName === 'IS') {
      if (parser.nextUpperArg() === 'NOT') {
        reverse = true;
        parser.skipArg(1);
      }

      const mapKey = parser.remainingLineMaybeVariable();
      const mapId = Managers.Map.getMapIdByLabel(mapKey);

      if (realMapId === mapId) {
        return !reverse;
      } else {
        return reverse;
      }
    }
  }

  static parse_holding(parser) {
    if (parser.upperName === 'ITEM') {
      return Managers.Items.isHoldingItem();
    }

    const itemName = parser.nameMaybeVariable();
    return (itemName && Managers.Items.isHoldingItem(itemName));
  }
}

Managers.Content.registerContentClass(ConditionParserContent);
