require('game/managers/Content');

function CompanionSkillsContent() {
}

CompanionSkillsContent.contentId = function() {
  return 'system#CompanionSkills';
};

CompanionSkillsContent.onChangeMinute = function() {
  if (!$gameParty.hasCompanion()) return;

  var companionName = $gameParty.getCompanionName();
  var lowerName = companionName.toLowerCase();

  // Devin will increase your friend points with male characters
  var devinOnParty = lowerName == 'devin';
  // Nathalia will increase your friend points with female characters
  var nathaliaOnParty = lowerName == 'nathalia';

  if (devinOnParty || nathaliaOnParty) {
    var devinLevel = Managers.Relationship.getHeartsNum('Devin');
    var nathaliaLevel = Managers.Relationship.getHeartsNum('Nathalia');

    var maleAdditionalPoints = devinOnParty ? Math.fix(devinLevel / 10) : 0;
    var femaleAdditionalPoints = nathaliaOnParty ? Math.fix(nathaliaLevel / 10) : 0;

    for (var i = 0; i < Managers.Relationship.data.knownVillagers.length; i++) {
      var villagerName = Managers.Relationship.data.knownVillagers[i];
      var actorData = Managers.Villagers.getActorData(villagerName);

      if (!actorData.gender) continue;

      if (maleAdditionalPoints > 0 && actorData.gender == 'male') {
        Managers.Relationship.increaseFriendship(villagerName, maleAdditionalPoints);
      }

      if (femaleAdditionalPoints > 0 && actorData.gender == 'female') {
        Managers.Relationship.increaseFriendship(villagerName, femaleAdditionalPoints);
      }
    }

    return;
  }

  if (lowerName == 'benjamin') {
    var benjaminLevel = Managers.Relationship.getHeartsNum('Benjamin');
    var animalAdditionalPoints = Math.fix(benjaminLevel / 10);

    for (var creatureName in Managers.Creatures.creatureList) {
      if (!Managers.Creatures.creatureList.hasOwnProperty(creatureName)) continue;

      var creatureData = Managers.Creatures.creatureList[creatureName];
      if (creatureData.friendship) {
        creatureData.friendship += animalAdditionalPoints;
      }
    }
  }
};

CompanionSkillsContent.getPurchaseDiscount = function(itemId) {
  //Raphael will get you a discount
  if (Managers.Villagers.isVillagerOnParty('Raphael')) {
    var hearts = Managers.Relationship.getHeartsNum('Raphael');
    if (hearts > 0) {
      return Math.fix(hearts * 4);
    }
  }

  return 0;
};

CompanionSkillsContent.canTeleportToMountains = function() {
  if (Managers.Villagers.isVillagerOnParty('Annie')) return true;
};
CompanionSkillsContent.canTeleportToMountainCave = function() {
  if (Managers.Villagers.isVillagerOnParty('Annie')) return true;
};
CompanionSkillsContent.canTeleportToForest = function() {
  if (Managers.Villagers.isVillagerOnParty('Annie')) return true;
};

CompanionSkillsContent.addAdditionalTeleportLocations = function(interpreter) {
  if (Managers.Villagers.isVillagerOnParty('Annie')) {
    // var hearts = Managers.Relationship.getHeartsNum('Annie');

    // interpreter.addChoice('North Orange Town');
    // interpreter.addChoice('East Orange Town');
    // interpreter.addChoice('Cemetery');
    // interpreter.addChoice('Train Station');
    // interpreter.addChoice('Mountain Camp');
  }
};

CompanionSkillsContent.performTeleport = function(destination) {
  // if (destination == 'Mountain Camp') {
  //   $gamePlayer.reserveTransfer(Maps.MOUNTAIN_CENTER, 52, 17, Direction.DOWN, 0, true);
  //   return;
  // }
};

CompanionSkillsContent.preventStaminaLoss = function(tool, levelUsed) {
  if (tool.toolName == 'teleport') {
    if (Managers.Villagers.isVillagerOnParty('Annie')) {
      return true;
    }
  }

  return false;
};

CompanionSkillsContent.getOreDropChange = function(typeData, currentChance, maxToolLevel) {
  if (!Managers.Villagers.isVillagerOnParty('Viktor')) return;

  var hearts = Managers.Relationship.getHeartsNum('Viktor');
  if (hearts > 0) {
    var multiplier = (hearts / 10) + 1;

    return Math.round(currentChance * multiplier);
  }
};

CompanionSkillsContent.getSecondDuration = function() {
  if (!Managers.Villagers.isVillagerOnParty('Julia')) return;

  var hearts = Managers.Relationship.getHeartsNum('Julia');

  return Managers.Time.secondDuration + hearts * 4;
};

Managers.Content.registerContentClass(CompanionSkillsContent);