require('game/managers/Content');

class StoryContent {
  static contentId() {
    return 'story';
  }

  static checkCutscenes(mapId) {
    if (this.checkCutsceneJuliaExplanation(mapId)) return true;
    if (this.checkCutsceneJuliaFirstIdea(mapId)) return true;
    return false;
  }

  static checkCutsceneJuliaExplanation(mapId) {
    if (Switches.playedStoryExplanation) return false;
    if (Variables.itemsShipped <= 0) return false;

    if (mapId !== Maps.FARM) return false;
    if (!$gameMap.isHome()) return false;

    if (Managers.Time.day < 5) return false;
    if (Managers.Time.hour < 6) return false;
    if (Managers.Time.hour > 20) return false;

    $gameTemp.reserveCutscene('julia_story_explanation');
    return true;
  }

  static checkCutsceneJuliaFirstIdea(mapId) {
    if (!Switches.playedStoryExplanation) return false;
    if (Switches.playedStoryFirstIdea) return false;

    if (mapId !== Maps.FARM) return false;
    if (!$gameMap.isHome()) return false;

    if (Managers.Time.day < 10) return false;
    if (Managers.Time.hour < 6) return false;
    if (Managers.Time.hour > 20) return false;

    $gameTemp.reserveCutscene('julia_story_first_idea');
    return true;
  }

  static parsePluginCommand(parser, command, args) {
    if (command.toUpperCase() === 'CREATE_DOG') {
      Managers.Creatures.createDog();
      return true;
    }
  }

  static parseConditionCommand(parser, command, args) {
    if (command.toUpperCase() === 'QUICK' && parser.upperName === 'START') {
      return $gameTemp.isQuickStart();
    }
  }
}

Managers.Content.registerContentClass(StoryContent);
