require('game/managers/Content');

class SteamCloudContent {
  static contentId() {
    return 'steam-cloud';
  }

  static makeModList(listWindow) {
    if (Managers.Steam.isSteamRunning()) {
      listWindow.addCommand(t("Steam Cloud"), 'mod_steam_cloud', true, 'subcategory');
    }
  }

  static makeSettingsList(listWindow) {
    const category = listWindow.category();
    if (category != 'mods') {
      return;
    }

    if (listWindow._subCategory != 'mod_steam_cloud') {
      return;
    }

    listWindow.addCommand(t("User Cloud Status"), 'mod_steam_cloud_user_cloud_status', true);
    listWindow.addCommand(t("Game Cloud Status"), 'mod_steam_cloud_game_cloud_status', true);

    if (Managers.Steam.isCloudUp()) {
      listWindow.addCommand(t("Sync Save Files"), 'mod_steam_cloud_download_files', true, 'action');
    }

    return true;
  }

  static confirmModSetting(listWindow, symbol) {
    if (!symbol.startsWith('mod_steam_cloud_')) {
      return;
    }

    switch (symbol.replace('mod_steam_cloud_', '')) {
      case 'user_cloud_status':
        listWindow.activate();
        break;
      case 'game_cloud_status':
        listWindow.activate();
        break;
      case 'download_files':
        listWindow.activate();
        Managers.Steam.syncAllSaves(() => {
          Managers.Scenes._scene.showAlert && Managers.Scenes._scene.showAlert(t("Syncronized Save Files."));
        });
        break;
    }
  }

  static _drawEnabledValue(listWindow, value, symbol, rect, index, trueValue = 'Enabled', falseValue = 'Disabled') {
    trueValue = trueValue || "Enabled";
    falseValue = falseValue || "Disabled";

    const x = rect.x + 140 * listWindow._zoomLevel;
    const color = value ? listWindow.blueColor() : listWindow.darkBaseColor();

    listWindow.contents.fillRect(x, rect.y, 46 * listWindow._zoomLevel, 14 * listWindow._zoomLevel, color);
    listWindow.drawText(value ? t(trueValue) : t(falseValue), x, rect.y - 2 * listWindow._zoomLevel, 46 * listWindow._zoomLevel, 'center');
  }

  static drawModSettingValue(listWindow, symbol, rect, index) {
    if (!symbol.startsWith('mod_steam_cloud_')) {
      return;
    }

    switch (symbol.replace('mod_steam_cloud_', '')) {
      case 'user_cloud_status':
        this._drawEnabledValue(listWindow, Managers.Steam.isCloudEnabledForUser(), symbol, rect, index);
        break;
      case 'game_cloud_status':
        this._drawEnabledValue(listWindow, Managers.Steam.isCloudEnabled(), symbol, rect, index);
        break;
    }

    return true;
  }

}

Managers.Content.registerContentClass(SteamCloudContent);