require('game/managers/Content');

class SeedBoxesContent {
  static contentId() {
    return 'seed-boxes';
  }

  static pickItem(item, amount, mailboxIfFull) {
    if (item.type == 'seed-box') {
      const seedId = item.id.replace('seed-box', 'seeds');
      return Managers.Items.pickItemId(seedId, amount * 10, mailboxIfFull);
    }

    return false;
  }

  static gainItem(item, amount, reverse, isNew) {
    if (item.type == 'seed-box') {
      const seedId = item.id.replace('seed-box', 'seeds');
      //Use "force" to make sure the item isn't lost, but in theory the box item can't be received if there's no space
      return Managers.Items.forceGainItemId(seedId, amount * 10, reverse, isNew);
    }

    return false;
  }
}

Managers.Content.registerContentClass(SeedBoxesContent);