require('game/managers/Content');

const saciList = [
  {
    id: 'red-1',
    mapId: Maps.MOUNTAIN,
    x: 31,
    y: 71,
    type: 'object',
    saciName: 'RedSaciKid',
    level: 1,
    conditions: [
      { type: 'weekday', value: 1 }
    ]
  },
  {
    id: 'red-2',
    mapId: Maps.FOREST,
    x: 4,
    y: 67,
    type: 'object',
    saciName: 'RedSaciKid',
    level: 1,
    conditions: [
      { type: 'weekday', value: 1 }
    ]
  },
  {
    id: 'red-3',
    mapId: Maps.BEACH,
    x: 0,
    y: 10,
    type: 'hidden',
    saciName: 'RedSaciKid',
    level: 1,
    offsetY: -8,
    eventPriority: 2,
    conditions: [
      // { type: 'weekday', value: 1 }
    ]
  },
  {
    id: 'red-4',
    mapId: Maps.MOUNTAIN_TOP,
    x: 24,
    y: 17,
    type: 'item',
    saciName: 'RedSaciKid',
    level: 1,
    itemName: 'spoiled-orange',
    conditions: [
      { type: 'weekday', value: 1 },
      {
        type: 'totalDays',
        min: 15
      },
      {
        type: 'month',
        value: 1
      }
    ]
  },
  {
    id: 'red-5',
    mapId: Maps.MOUNTAIN,
    x: 31,
    y: 31,
    type: 'item',
    saciName: 'RedSaciKid',
    level: 1,
    itemName: 'golden-orange',
    conditions: [
      { type: 'weekday', value: 1 }
    ]
  },
  {
    id: 'red-6',
    mapId: Maps.FOREST,
    x: 39,
    y: 68,
    type: 'object',
    saciName: 'RedSaciKid',
    level: 1,
    conditions: [
      { type: 'weekday', value: 1 }
    ]
  },
  {
    id: 'red-7',
    mapId: Maps.ORANGE_TOWN,
    x: 48,
    y: 34,
    type: 'object',
    saciName: 'RedSaciKid',
    level: 1,
    conditions: [
      { type: 'weekday', value: 1 }
    ]
  },
  {
    id: 'red-8',
    mapId: Maps.ORANGE_TOWN,
    x: 24,
    y: 34,
    type: 'hidden',
    saciName: 'RedSaciKid',
    level: 1,
    conditions: [
      // { type: 'weekday', value: 1 }
    ]
  },
  {
    id: 'red-9',
    mapId: Maps.FOREST,
    x: 42,
    y: 53,
    type: 'object',
    saciName: 'RedSaciKid',
    level: 1,
    conditions: [
      { type: 'weekday', value: 1 }
    ]
  },
  {
    id: 'red-10',
    mapId: Maps.FOREST,
    x: 73,
    y: 55,
    type: 'object',
    saciName: 'RedSaciKid',
    level: 1,
    conditions: [
      { type: 'weekday', value: 1 }
    ]
  },
  {
    id: 'red-11',
    mapId: Maps.MOUNTAIN,
    x: 3,
    y: 36,
    type: 'object',
    saciName: 'RedSaciKid',
    level: 1,
    conditions: [
      { type: 'weekday', value: 1 }
    ]
  },
  {
    id: 'red-12',
    mapId: Maps.MOUNTAIN,
    x: 45,
    y: 33,
    type: 'object',
    saciName: 'RedSaciKid',
    level: 1,
    conditions: [
      { type: 'weekday', value: 1 }
    ]
  },
  {
    id: 'red-13',
    mapId: Maps.MOUNTAIN,
    x: 53,
    y: 33,
    type: 'object',
    saciName: 'RedSaciKid',
    level: 1,
    conditions: [
      { type: 'weekday', value: 1 }
    ]
  },
  {
    id: 'red-14',
    mapId: Maps.MOUNTAIN,
    x: 11,
    y: 34,
    type: 'object',
    saciName: 'RedSaciKid',
    level: 1,
    conditions: [
      { type: 'weekday', value: 1 }
    ]
  },
  {
    id: 'red-15',
    mapId: Maps.MOUNTAIN,
    x: 24,
    y: 23,
    type: 'object',
    saciName: 'RedSaciKid',
    level: 1,
    conditions: [
      { type: 'weekday', value: 1 }
    ]
  },
  {
    id: 'red-16',
    mapId: Maps.ORANGE_TOWN,
    x: 57,
    y: 64,
    type: 'hidden',
    saciName: 'RedSaciKid',
    level: 1,
    offsetX: 8,
    offsetY: -8,
    conditions: [
      // { type: 'weekday', value: 1 }
    ]
  },
  {
    id: 'red-17',
    mapId: Maps.ORANGE_TOWN,
    x: 50,
    y: 19,
    type: 'hidden',
    saciName: 'RedSaciKid',
    level: 1,
    offsetY: -32,
    conditions: [
      // { type: 'weekday', value: 1 }
    ]
  },
  {
    id: 'red-18',
    mapId: Maps.MOUNTAIN,
    x: 18,
    y: 36,
    type: 'object',
    saciName: 'RedSaciKid',
    level: 1,
    conditions: [
      { type: 'weekday', value: 1 }
    ]
  },
  {
    id: 'red-19',
    mapId: Maps.MOUNTAIN,
    x: 10,
    y: 53,
    type: 'object',
    saciName: 'RedSaciKid',
    level: 1,
    conditions: [
      { type: 'weekday', value: 1 }
    ]
  },
  {
    id: 'red-20',
    mapId: Maps.MOUNTAIN_TOP,
    x: 31,
    y: 5,
    type: 'object',
    saciName: 'RedSaciKid',
    level: 1,
    conditions: [
      { type: 'weekday', value: 1 }
    ]
  },



  {
    id: 'blue-1',
    mapId: Maps.MOUNTAIN,
    x: 27,
    y: 60,
    type: 'object',
    saciName: 'BlueSaciKid',
    level: 2,
    conditions: [
      { type: 'weekday', value: 2 }
    ]
  },
  {
    id: 'blue-2',
    mapId: Maps.MOUNTAIN_TOP,
    x: 51,
    y: 14,
    type: 'object',
    saciName: 'BlueSaciKid',
    level: 2,
    conditions: [
      { type: 'weekday', value: 2 }
    ]
  },
  {
    id: 'blue-3',
    mapId: Maps.FOREST,
    x: 73,
    y: 34,
    type: 'object',
    saciName: 'BlueSaciKid',
    level: 2,
    conditions: [
      { type: 'weekday', value: 2 }
    ]
  },
  {
    id: 'blue-4',
    mapId: Maps.FOREST,
    x: 35,
    y: 65,
    type: 'item',
    itemName: 'rock',
    freeItem: true,
    saciName: 'BlueSaciKid',
    level: 2,
    conditions: [
      { type: 'weekday', value: 2 }
    ]
  },
  {
    id: 'blue-5',
    mapId: Maps.ORANGE_TOWN,
    x: 73,
    y: 2,
    type: 'object',
    saciName: 'BlueSaciKid',
    level: 2,
    conditions: [
      { type: 'weekday', value: 2 }
    ]
  },
  {
    id: 'blue-6',
    mapId: Maps.ORANGE_TOWN,
    x: 23,
    y: 1,
    type: 'item',
    itemName: 'rock',
    freeItem: true,
    saciName: 'BlueSaciKid',
    level: 2,
    conditions: [
      { type: 'weekday', value: 2 }
    ]
  },
  {
    id: 'blue-7',
    mapId: Maps.BEACH,
    x: 6,
    y: 4,
    type: 'object',
    saciName: 'BlueSaciKid',
    level: 2,
    conditions: [
      { type: 'weekday', value: 2 },
      {
        type: 'day',
        min: 16
      }
    ]
  },
  {
    id: 'blue-8',
    mapId: Maps.FOREST,
    x: 63,
    y: 22,
    type: 'object',
    saciName: 'BlueSaciKid',
    level: 2,
    conditions: [
      { type: 'weekday', value: 2 }
    ]
  },
  {
    id: 'blue-9',
    mapId: Maps.ORANGE_TOWN,
    x: 72,
    y: 57,
    type: 'hidden',
    saciName: 'BlueSaciKid',
    level: 2,
    offsetY: -16,
    eventPriority: 2,
    conditions: [
      // { type: 'weekday', value: 2 }
    ]
  },
  {
    id: 'blue-10',
    mapId: Maps.ORANGE_TOWN,
    x: 49,
    y: 23,
    type: 'hidden',
    saciName: 'BlueSaciKid',
    level: 2,
    conditions: [
      // { type: 'weekday', value: 2 }
    ]
  },
  {
    id: 'blue-11',
    mapId: Maps.MOUNTAIN_TOP,
    x: 56,
    y: 16,
    type: 'item',
    itemName: 'rock',
    freeItem: true,
    saciName: 'BlueSaciKid',
    level: 2,
    conditions: [
      { type: 'weekday', value: 2 }
    ]
  },
  {
    id: 'blue-12',
    mapId: Maps.MOUNTAIN,
    x: 8,
    y: 11,
    type: 'object',
    saciName: 'BlueSaciKid',
    level: 2,
    conditions: [
      { type: 'weekday', value: 2 }
    ]
  },
  {
    id: 'blue-13',
    mapId: Maps.MOUNTAIN,
    x: 36,
    y: 14,
    type: 'item',
    itemName: 'wooden-stick',
    freeItem: true,
    saciName: 'BlueSaciKid',
    level: 2,
    conditions: [
      { type: 'weekday', value: 2 }
    ]
  },
  {
    id: 'blue-14',
    mapId: Maps.BEACH,
    x: 26,
    y: 13,
    type: 'item',
    itemName: 'old-tire',
    saciName: 'BlueSaciKid',
    level: 2,
    conditions: [
      { type: 'weekday', value: 2 },
      {
        type: 'day',
        max: 15
      }
    ]
  },
  {
    id: 'blue-15',
    mapId: Maps.MOUNTAIN_TOP,
    x: 64,
    y: 1,
    type: 'object',
    saciName: 'BlueSaciKid',
    level: 2,
    conditions: [
      { type: 'weekday', value: 2 }
    ]
  },
  {
    id: 'blue-16',
    mapId: Maps.ORANGE_TOWN,
    x: 11,
    y: 53,
    type: 'object',
    saciName: 'BlueSaciKid',
    level: 2,
    conditions: [
      { type: 'weekday', value: 2 }
    ]
  },
  {
    id: 'blue-17',
    mapId: Maps.ORANGE_TOWN,
    x: 26,
    y: 17,
    type: 'object',
    saciName: 'BlueSaciKid',
    level: 2,
    conditions: [
      { type: 'weekday', value: 2 }
    ]
  },
  {
    id: 'blue-18',
    mapId: Maps.ORANGE_TOWN,
    x: 11,
    y: 25,
    type: 'object',
    saciName: 'BlueSaciKid',
    level: 2,
    conditions: [
      { type: 'weekday', value: 2 }
    ]
  },
  {
    id: 'blue-19',
    mapId: Maps.FARM,
    x: 3,
    y: 12,
    type: 'object',
    saciName: 'BlueSaciKid',
    level: 2,
    conditions: [
      { type: 'weekday', value: 2 }
    ]
  },
  {
    id: 'blue-20',
    mapId: Maps.FOREST_CENTER,
    x: 13,
    y: 2,
    type: 'object',
    saciName: 'BlueSaciKid',
    level: 2,
    conditions: [
      { type: 'weekday', value: 2 }
    ]
  },


  {
    id: 'green-1',
    mapId: Maps.ORANGE_TOWN,
    x: 51,
    y: 70,
    type: 'hidden',
    saciName: 'GreenSaciKid',
    offsetY: 24,
    level: 3,
    conditions: [
      // { type: 'weekday', value: 3 }
    ]
  },
  {
    id: 'green-2',
    mapId: Maps.FOREST,
    x: 58,
    y: 52,
    type: 'object',
    saciName: 'GreenSaciKid',
    level: 3,
    conditions: [
      { type: 'weekday', value: 3 }
    ]
  },
  {
    id: 'green-3',
    mapId: Maps.BEACH,
    x: 2,
    y: 14,
    type: 'item',
    itemName: 'seashell',
    saciName: 'GreenSaciKid',
    level: 3,
    conditions: [
      { type: 'weekday', value: 3 }
    ]
  },
  {
    id: 'green-4',
    mapId: Maps.FOREST,
    x: 67,
    y: 60,
    type: 'object',
    saciName: 'GreenSaciKid',
    level: 3,
    conditions: [
      { type: 'weekday', value: 3 }
    ]
  },
  {
    id: 'green-5',
    mapId: Maps.ORANGE_TOWN,
    x: 12,
    y: 17,
    type: 'hidden',
    saciName: 'GreenSaciKid',
    level: 3,
    offsetY: -24,
    eventPriority: 2,
    conditions: [
      // { type: 'weekday', value: 3 }
    ]
  },
  {
    id: 'green-6',
    mapId: Maps.FESTIVAL_RECEPTION,
    x: 12,
    y: 11,
    type: 'hidden',
    saciName: 'GreenSaciKid',
    level: 3,
    offsetY: -24,
    eventPriority: 1,
    conditions: [
      // { type: 'weekday', value: 3 }
    ]
  },
  {
    id: 'green-7',
    mapId: Maps.MOUNTAIN,
    x: 4,
    y: 62,
    type: 'object',
    saciName: 'GreenSaciKid',
    level: 3,
    conditions: [
      { type: 'weekday', value: 3 }
    ]
  },
  {
    id: 'green-8',
    mapId: Maps.BEACH,
    x: 13,
    y: 15,
    type: 'hidden',
    saciName: 'GreenSaciKid',
    level: 3,
    offsetY: -8,
    eventPriority: 2,
    conditions: [
      // { type: 'weekday', value: 3 }
    ]
  },
  {
    id: 'green-9',
    mapId: Maps.MOUNTAIN,
    x: 64,
    y: 19,
    type: 'hidden',
    saciName: 'GreenSaciKid',
    level: 3,
    conditions: [
      // { type: 'weekday', value: 3 }
    ]
  },
  {
    id: 'green-10',
    mapId: Maps.MAZE,
    x: 35,
    y: 27,
    type: 'object',
    saciName: 'GreenSaciKid',
    level: 3,
    conditions: [
      { type: 'weekday', value: 3 }
    ]
  }
];

const statuses = {};

function clearSaciStatuses() {
  for (let key in statuses) {
    delete statuses[key];
  }
}

function getSaciStatus(saciId) {
  return statuses[saciId] || false;
}

function getSaciDataByPosition(mapId, x, y) {
  for (const saciData of saciList) {
    if (saciData.mapId !== mapId) continue;
    if (saciData.x !== x) continue;
    if (saciData.y !== y) continue;

    return saciData;
  }

  return false;
}

function setSaciStatus(saciId, status) {
  statuses[saciId] = status;
}

function validateConditions(saciData) {
  const { conditions } = saciData;

  for (const cond of conditions) {
    switch (cond.type) {
      case 'weekday':
        if ('value' in cond) {
          if (Managers.Time.weekday !== cond.value) {
            return false;
          }
        }
        if ('min' in cond) {
          if (Managers.Time.weekday < cond.min) {
            return false;
          }
        }
        if ('max' in cond) {
          if (Managers.Time.weekday > cond.max) {
            return false;
          }
        }
        break;
      case 'weather':
        if (Managers.Weather.currentWeather !== cond.value) {
          return false;
        }
        break;
      case 'hour':
        if ('value' in cond) {
          if (Managers.Time.hour !== cond.value) {
            return false;
          }
        }
        if ('min' in cond) {
          if (Managers.Time.hour < cond.min) {
            return false;
          }
        }
        if ('max' in cond) {
          if (Managers.Time.hour > cond.max) {
            return false;
          }
        }
        break;
      case 'day':
        if ('value' in cond) {
          if (Managers.Time.day !== cond.value) {
            return false;
          }
        }
        if ('min' in cond) {
          if (Managers.Time.day < cond.min) {
            return false;
          }
        }
        if ('max' in cond) {
          if (Managers.Time.day > cond.max) {
            return false;
          }
        }
        break;
      case 'totalDays':
        if (Managers.Time.totalDays < (cond.value || cond.min || 0)) {
          return false;
        }
        break;
      case 'month':
        if ('value' in cond) {
          if (Managers.Time.month !== cond.value) {
            return false;
          }
        }
        if ('min' in cond) {
          if (Managers.Time.month < cond.min) {
            return false;
          }
        }
        if ('max' in cond) {
          if (Managers.Time.month > cond.max) {
            return false;
          }
        }
        break;
    }
  }
  
  return true;  
}

function createIconEvent(saciData) {
  $gameMap.createActionIconEventAt(saciData.iconIndex, saciData.x, saciData.y, 'trigger_saci_icon', true);
}

function createTileEvent(saciData) {
  $gameMap.createActionTileEventCallAt(saciData.tileId, saciData.x, saciData.y, 'trigger_saci_icon', true);
}

function createItemEvent(saciData, firstOfTheDay) {
  if (!firstOfTheDay) {
    return;
  }

  if (!TileHelper.isTileEmpty(saciData.x, saciData.y, true, false, false, false)) {
    return;
  }

  const farmObject = Managers.FarmObjects.createItemAt(saciData.mapId, saciData.x, saciData.y, saciData.itemName, 1);
  farmObject.updateEvents();

  setSaciStatus(saciData.id, 'created-temp');
}

function removeSaciEvent(saciData) {
  Managers.FarmObjects.eraseFarmObjectsXy(saciData.mapId, saciData.x, saciData.y);
  setSaciStatus(saciData.id, false);
}

function updateTempSaciEvent(saciData, firstOfTheDay) {
  const events = $gameMap.eventsXy(saciData.x, saciData.y);

  const valid = validateConditions(saciData);

  if (events && events.length) {
    if (!valid) {
      for (const event of events) {
        if (event) {
          event.erase();
        }
      }

      setSaciStatus(saciData.id, false);
    }

    return;
  }

  if (valid) {
    createSaciEvent(saciData, firstOfTheDay);
  }
}

function createInvisibleEvent(saciData) {
  $gameMap.createEventCallAt(saciData.x, saciData.y, 'trigger_saci_icon', 1, true, Objects.HiddenSaciObject);
}

function createSaciEvent(saciData, firstOfTheDay) {
  if (!validateConditions(saciData)) {
    return;
  }

  if (Variables.unlockedSaciLevel < saciData.level) {
    if (saciData.type == 'item' && saciData.freeItem) {
      createItemEvent(saciData, firstOfTheDay);
    }
    return;
  }

  switch(saciData.type) {
    case 'icon':
      createIconEvent(saciData);
      break;
    case 'tile':
      createTileEvent(saciData);
      break;
    case 'item':
      createItemEvent(saciData, firstOfTheDay);
      return;
    case 'object':
      break;
    case 'hidden':
      createInvisibleEvent(saciData);
      setSaciStatus(saciData.id, 'created-temp');
      return;
    default:
      return;
  }

  setSaciStatus(saciData.id, 'created');
}

function showSaci(saciData) {
  Managers.Images.loadCharacter('villagers/saci-kids');
  Managers.Images.loadCharacter('villagers/saci-kids-spawn');
  Managers.Images.loadCharacter('villagers/saci-kids-despawn');

  const saciEvent = $gameMap.createVillagerByNameAt(saciData.saciName, saciData.x, saciData.y, 2, false, undefined, true);
  if (!saciEvent) {
    throw new Error(`Failed to create new Saci (${ saciData.saciName })`);
  }

  const originalSprite = saciEvent._characterName;
  saciEvent._pattern = 0;
  saciEvent._lockPattern = true;
  saciEvent._characterName += '-spawn';

  saciEvent.offsetX = saciData.offsetX || 0;
  saciEvent.offsetY = saciData.offsetY || 0;
  saciEvent._priorityType = saciData.eventPriority !== undefined ? saciData.eventPriority : 1;

  Switches.holdPlayer = true;
  $gamePlayer.requestBalloon(Balloons.EXCLAMATION);

  setSaciStatus(saciData.id, 'found');
  Variables.sacisFound++;

  const frames = 5;

  const animation = [
    { frames, pattern: 1 },
    { frames, pattern: 2 },
    { frames, pattern: 0, direction: 4 },
    { frames, pattern: 1 },
    { frames, pattern: 2 },
    { frames, pattern: 0, direction: 6 },
    { frames, pattern: 1, direction: 2, method: () => { 
      saciEvent._characterName = originalSprite;
      saciEvent._lockPattern = false;
      saciEvent._moveSpeed = 5;
      saciEvent._moveFrequency = 5;
      saciEvent._stepAnime = true;
    }},
    { frames, method: () => {
      saciEvent.turnTowardCharacter($gamePlayer);
      saciEvent.requestBalloon(Balloons.QUESTION);
    }},
    { frames: frames * 16, pattern: 0, direction: 2, method: () => {
      saciEvent._stepAnime = false;
      saciEvent._lockPattern = true;
      saciEvent._characterName = `${ originalSprite }-despawn`;
    }},
    { frames, pattern: 1 },
    { frames, pattern: 2 },
    { frames, pattern: 0, direction: 4 },
    { frames, pattern: 1 },
    { frames, pattern: 2 },
    { frames, pattern: 0, direction: 6 },
    { frames, pattern: 1 },
    { frames, pattern: 2 },
    { frames, pattern: 0, direction: 8 },
    { frames, method: () => {
      saciEvent.erase();

      Switches.holdPlayer = false;
      if (Variables.sacisFound % 20 === 0) {
        Managers.Health.maxFatigue = 100 + Math.floor(Variables.sacisFound / 20) * 10;
        Managers.CommonEvent.playEvent('player_update_fatigue');
      } else if (Variables.sacisFound === 1) {
        Managers.CommonEvent.playEvent('player_found_first_saci');
      } else {
        Managers.CommonEvent.playEvent('player_found_new_saci');
      }
    }}
  ];

  $gameTemp.playAnimationStep(animation, saciEvent, 0);
}

function showSaciXy(x, y) {
  const saciData = getSaciDataByPosition($gameMap._mapId, x, y);
  if (!saciData) {
    return;
  }

  if (Variables.unlockedSaciLevel < saciData.level) {
    return;
  }

  $gameTemp.setTimeout(() => {
    showSaci(saciData);
  }, 3);

  return true;
}

// function checkIfLevelIsComplete(level) {
//   let count = 0;
//   let total = 0;

//   for (const saciData of saciList) {
//     if (saciData.level !== level) continue;

//     total++;

//     if (getSaciStatus(saciData.id) === true) {
//       count++;
//     }
//   }

//   return total > 0 && count === total;
// }

class SaciSpawnsContent {
  static contentId() {
    return 'saci-spawns';
  }

  static setupMapEvents(firstOfTheDay) {
    for (const saciData of saciList) {
      if (saciData.mapId != $gameMap._mapId) continue;

      const status = getSaciStatus(saciData.id);
      if (status === false) {
        if (validateConditions(saciData)) {
          createSaciEvent(saciData, firstOfTheDay);
        }
        continue;
      }

      if (status === 'created') {
        if (!validateConditions(saciData)) {
          removeSaciEvent(saciData);
        }

        continue;
      }

      if (status === 'created-temp') {
        updateTempSaciEvent(saciData, firstOfTheDay);
      }
    }
  }

  static makeSaveContents(contents) {
    contents.sacis = statuses;
  }

  static extractSaveContents(contents) {
    clearSaciStatuses();

    if (contents.sacis) {
      for (const saciData of saciList) {
        if (contents.sacis[saciData.id]) {
          setSaciStatus(saciData.id, contents.sacis[saciData.id]);
        }
      }
    }
  }

  static setupNewGame() {
    clearSaciStatuses();
  }

  static onClearObject(object) {
    // Check if there's a saci on that position
    const { mapId, x, y } = object;
    const saciData = getSaciDataByPosition(mapId, x, y);
    if (!saciData) {
      return;
    }

    if (getSaciStatus(saciData.id) === 'found') {
      return;
    }

    if (Variables.unlockedSaciLevel < saciData.level) {
      return;
    }

    // We do not check if the conditions are valid, because if only determines if the object should exist or not, not the saci itself.
    // If for some reason the object is there when the conditions are not met (example: It's a daily object), then we still want the saci to be found
    // Otherwise the player may think they already tried that object and not try again

    $gameTemp.setTimeout(() => {
      showSaci(saciData);
    }, 3);

    return true;
  }

  static parsePluginCommand(parser, command, args) {
    if (command.toUpperCase() !== 'SACI') {
      return;
    }

    if (parser.name.toUpperCase() == 'SHOW') {
      const event = $gameMap._interpreter.character(0);

      showSaciXy(event.x, event.y);
      event.erase();
      return true;
    }
  }
}

Managers.Content.registerContentClass(SaciSpawnsContent);